\name{ppstat-package}
\alias{ppstat-package}
\alias{ppstat}
\docType{package}
\title{ Point Process Statistics
}
\description{

This package implements statistical methods for one-dimensional marked
point process models.

}
\details{
\tabular{ll}{
Package: \tab ppstat\cr
Type: \tab Package\cr
Version: \tab 0.9 \cr
Date: \tab 2013-04-05 \cr
License: \tab GPL version 2 or newer \cr
URL: \tab http://www.math.ku.dk/~richard/ppstat \cr
LazyLoad: \tab yes\cr
}

The package provides a framework for analyzing data from multivariate
point processes in time or one-dimensional space, aka marked point
processes with discrete marks, based on a specification of the
conditional intensity process. The main function is
\code{\link{pointProcessModel}}, which constructs and fits a
generalized linear point process model to a dataset. The data need to be
stored as an object of S4-class
\code{\linkS4class{MarkedPointProcess}}. A \code{MarkedPointProcess}
object can hold data from a marked point process as well as additional
(covariate) continuous processes. Other functions are
\code{\link{ppSmooth}} and \code{\link{ppKernel}} that implement
non-parametric estimaton of linear filter functions.

The data structures for continuous and marked point processes are
implemented in the separate package \code{\link{processdata}}.

}
\author{
Niels Richard Hansen \email{Niels.R.Hansen@math.ku.dk}.

Maintainer: \email{Niels.R.Hansen@math.ku.dk}
}
\references{

  
Andersen, P. K., Borgan, OE., Gill, R. D. and Keiding,
N. \emph{Statistical models based on counting processes}. Springer
Series in Statistics, 1993. 

Cook, R. J. and Lawless, J. F. \emph{The Statistical Analysis of
  Recurrent Events }. Springer Series in Statistics for Biology and
Health. 2007

Daley, D. J. and Vere-Jones, D. \emph{An introduction to the theory of
  point processes. Vol. I.} Springer Series in Probability and its
  Applications, 2003.

Jacobsen, M. \emph{Point process theory and applications.} Birkhauser Series in
Probability and its Applications, 2006.

Hansen, N. R. \emph{Penalized maximum likelihood estimation for
  generalized linear point processes}. 	arXiv:1003.0848v1 


}

\seealso{

  \code{\linkS4class{MarkedPointProcess}},
  \code{\linkS4class{PointProcessModel}},
  \code{\link{pointProcessModel}},
   \code{\link{ppSmooth}}
   \code{\link{ppKernel}}


}

\keyword{models}
