% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SM_output.logis_fe.R
\name{SM_output.logis_fe}
\alias{SM_output.logis_fe}
\title{Calculate direct/indirect standardized ratios/rates from a fitted \code{logis_fe} object}
\usage{
\method{SM_output}{logis_fe}(
  fit,
  parm,
  stdz = "indirect",
  measure = c("rate", "ratio"),
  null = "median",
  threads = 2,
  ...
)
}
\arguments{
\item{fit}{a model fitted from \code{logis_fe}.}

\item{parm}{specifies a subset of providers for which confidence intervals are to be given.
By default, all providers are included. The class of \code{parm} should match the class of the provider IDs.}

\item{stdz}{a character string or a vector specifying the standardization method(s).
The possible values are:
\itemize{
\item{\code{"indirect"}} (default) indirect standardization method.
\item{\code{"direct"}} direct standardization method.
\item{\code{c("indirect", "direct")}} outputs both direct and indirect standardized measures.
}}

\item{measure}{a character string or a vector indicating whether the output measure is "ratio" or "rate"
\itemize{
\item{\code{"rate"}} output the standardized rate. The "rate" has been restricted to 0\% - 100\%.
\item{\code{"ratio"}} output the standardized ratio.
\item{\code{c("ratio", "rate")}} (default) output both the ratio and rate.
}}

\item{null}{if \code{"stdz = indirect"}, a character string or a number defining the population norm. The default is "median".}

\item{threads}{an integer specifying the number of threads to use. The default value is 2.}

\item{\dots}{additional arguments that can be passed to the function.}
}
\value{
A list contains standardized measures, as well as the observed and expected outcomes used for calculation,
depending on the user's choice of standardization method (\code{stdz}) and measure type (\code{measure}).
\item{indirect.ratio}{standardization ratio using indirect method if \code{stdz} includes \code{"indirect"} and \code{measure} includes \code{"ratio"}.}
\item{direct.ratio}{standardization ratio using direct method if \code{stdz} includes \code{"direct"} and \code{measure} includes \code{"ratio"}.}
\item{indirect.rate}{standardization rate using indirect method if \code{stdz} includes \code{"indirect"} and \code{measure} includes \code{"rate"}.}
\item{direct.rate}{standardization rate using direct method if \code{stdz} includes \code{"direct"} and \code{measure} includes \code{"rate"}.}
\item{OE}{a list of data frames containing the observed and expected outcomes used for calculating standardized measures.}
}
\description{
Provide direct/indirect standardized ratios/rates for a fixed effect logistic model.
}
\examples{
data(ExampleDataBinary)
outcome = ExampleDataBinary$Y
covar = ExampleDataBinary$Z
ID = ExampleDataBinary$ID
fit_fe <- logis_fe(Y = outcome, Z = covar, ID = ID, message = FALSE)
SR <- SM_output(fit_fe, stdz = "direct", measure = "rate")
SR$direct.rate

}
\references{
He, K. (2019). Indirect and direct standardization for evaluating transplant centers. \emph{Journal of Hospital Administration}, \strong{8(1)}, 9-14.
\cr
}
