% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppiBGD2013}
\alias{ppiBGD2013}
\title{ppiBGD2013}
\format{A data frame with 10 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nl}}{National lower poverty line}
\item{\code{nu100}}{National upper poverty line (100\%)}
\item{\code{nu150}}{National upper poverty line (150\%)}
\item{\code{nu200}}{National upper poverty line (200\%)}
\item{\code{extreme}}{USAID extreme poverty}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp175}}{Below $1.75 per day purchasing power parity (2005)}
\item{\code{ppp200}}{Below $2.00 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
}}
\source{
\url{www.povertyindex.org}
}
\usage{
ppiBGD2013
}
\description{
Poverty Probability Index (PPI) lookup table for Bangladesh
}
\examples{
  # Access Bangladesh PPI table
  ppiBGD2013

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiBGD2013[ppiBGD2013$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiBGD2013, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the USAID
  # extreme poverty definition
  ppiScore <- 50
  ppiBGD2013[ppiBGD2013$score == ppiScore, "extreme"]

}
\keyword{datasets}
