% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTimeSlice.R
\name{getTimeSlice}
\alias{getTimeSlice}
\title{getTimeSlice}
\usage{
getTimeSlice(timeSlice, tree, trait, model = "BM", plot.est = FALSE)
}
\arguments{
\item{timeSlice}{single numeric or a vector with the time (or times) to extract the estimated ancestor reconstructions.}

\item{tree}{an object of the class "phylo" that should be dated}

\item{trait}{a vector of both tip values and node estimates that correspond to tree}

\item{model}{if model = "estimate", the best fit model of evolution. If the model was specified, then model is the specified model, passes to \code{geiger::fitContinuous()}. Model options currently supported are: "BM", "OU", "EB", "lambda", "kappa", "delta"}

\item{plot.est}{a conditional stating whether or not to plot the results}
}
\value{
\code{edge} for each time specified, a vector of edges that are present during that time are returned

\code{est} for each time specified, a vector of estimates of the ancestral reconstruction along each edge
}
\description{
This function extracts estimated ancestral reconstructions for continuous characters any time specified along a phylogeny for all lineages present at the specified time.
}
\details{
The estimated reconstruction relies on an interpolation between node or between tip and node estimates of the trait. This method assumes a constant rate of evolution along the lineage where the interpolation is taking place.
}
\examples{
data(sampletrees)
data(occurrences)
occurrences <- getBioclimVars(occurrences, which.biovars=1)
sp_data_min<- tapply(occurrences[,4],occurrences$Species,min)
treedata_min <- geiger::treedata(sampletrees[[1]], sp_data_min)
\donttest{ex_est <- nodeEstimate(treedata_min, 1, model = 'BM') #runs BM model
ex_timeSlice <- getTimeSlice(10,treedata_min$phy,c(treedata_min$data[,1],ex_est$est))}
}
\seealso{
\code{geiger::fitContinuous()}, \code{nodeEstimate()}
}
\author{
A. Michelle Lawing, Alexandra F. C. Howard
}
