% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/re.clustsize.cont.R
\name{re.clustsize.cont}
\alias{re.clustsize.cont}
\title{Relative efficiency of a cluster randomized or multisite trial with continuous outcome
with varying cluster sizes}
\usage{
re.clustsize.cont(m, m.sd, icc)
}
\arguments{
\item{m}{The number of subjects per cluster or the mean cluster size (if unequal number of participants per cluster).}

\item{m.sd}{The standard deviation of cluster sizes (in case of unequal number of participants per cluster).}

\item{icc}{The intraclass correlation coefficient. For a multisite trial this is icc1. For a CRT this is the average of the 2 icc's.}
}
\value{
The computed RE.
}
\description{
For a continuous outcome, computes the relative efficiency (ratio of the variances) of a cluster randomized
or multisite trial with varying cluster (site) sizes to that of a trial with constant cluster sizes,
assuming equal total number of subjects. This approximation may not be valid for all combinations of
parameters, for example when m.sd is large.
}
\examples{
re.clustsize.cont(m = 25, m.sd = 15, icc = 0.05)
}
