% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es.w.R
\name{es.w}
\alias{es.w}
\title{Cohen w effect size calculation for chi-square tests}
\usage{
es.w(p0vec = NULL, p1vec = NULL, pmatrix = NULL)
}
\arguments{
\item{p0vec}{The first vector of probabilities. Both p0vec and p1vec, or pmatrix must be specified.}

\item{p1vec}{The second vector of probabilities. Both p0vec and p1vec, or pmatrix must be specified.}

\item{pmatrix}{The two-way probability table. Both p0vec and p1vec, or pmatrix must be specified.}
}
\value{
A list of the arguments and the w effect size.
}
\description{
Calculates the w effect size for chi-square tests. For chi-square goodness of fit tests, specify
p0vec and p1vec. For chi-square tests of independence, provide a matrix of cell probabilities.
Based on Cohen (1988).
}
\details{
Cohen J (1988) Statistical Power Analysis for the Behavioral Sciences, 2nd edition.
Lawrence Erlbaum Associates, Hillsdale, New Jersey
}
\examples{
es.w(p0vec = c(0.5, 0.3, 0.2), p1vec = c(0.7, 0.2, 0.1))
es.w(pmatrix = matrix(c(0.050, 0.350, 0.100, 0.075, 0.250, 0.175), nrow = 2, byrow = TRUE))
}
