% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{update.plcp}
\alias{update.plcp}
\title{Update a \code{study_parameters}-object with new settings}
\usage{
\method{update}{plcp}(object, ...)
}
\arguments{
\item{object}{An object created by \code{\link{study_parameters}}}

\item{...}{Any number of named arguments that should be updated}
}
\description{
Update a \code{study_parameters}-object with new settings
}
\details{
Currently only the arguments used to construct the original object
can be updated.
}
\examples{
p <- study_parameters(n1 = 11,
                      n2 = 10,
                      n3 = 3,
                      T_end = 10,
                      icc_pre_subject = 0.5,
                      icc_pre_cluster = 0,
                      var_ratio = 0.03,
                      icc_slope = 0.05,
                      cohend = -0.8)

p <- update(p, icc_slope = 0.1)
get_ICC_slope(p)

\dontrun{
# Using a "new" argument does not work (yet)
update(p, sigma_cluster_slope = 2)
}
}
