% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get_var_ratio}
\alias{get_var_ratio}
\title{Calculates the ratio of the slope variance to the within-subjects error variance}
\usage{
get_var_ratio(object, ...)
}
\arguments{
\item{object}{An object created by \code{\link{study_parameters}}}

\item{...}{Optional arguments.}
}
\value{
Returns the ratio of the total slope variance to the within-subject error
 as a numeric vector.
}
\description{
Calculates the ratio of the slope variance to the within-subjects error variance
}
\examples{
paras <- study_parameters(n1 = 11,
                          n2 = 10,
                          n3 = 3,
                          T_end = 10,
                          sigma_subject_intercept = 1.2,
                          sigma_subject_slope = 0.2,
                          sigma_cluster_intercept = 0,
                          sigma_cluster_slope = 0.2,
                          sigma_error = 1.2,
                          cohend = -0.8)

get_var_ratio(paras)
}
