% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.R
\name{get_power}
\alias{get_power}
\title{Calculate power for two- and three-level models with missing data.}
\usage{
get_power(object, ...)
}
\arguments{
\item{object}{An object created by \code{\link{study_parameters}}}

\item{...}{Other potential arguments; currently used to pass progress bar from
Shiny}
}
\value{
a \code{list} or \code{data.frame} depending if power is calculated for a
single set of parameters or a combination of multiple values. Has class
\code{plcp_power_3lvl} for fully- and partially nested three-level designs,
 and class \code{plcp_power_2lvl} for two-level designs.
}
\description{
Calculate power for two- and three-level models with missing data.
}
\details{
\bold{Calculations of standard errors}
Designs with equal cluster sizes, and with no missing data, uses standard closed form equations to
calculate standard errors. Designs with missing data or unequal cluster sizes uses more
computationally intensive linear algebra solutions.

To see a more detailed explanation of the calculations, type
\code{vignette("technical", package = "powerlmm")}.

\bold{Degrees of freedom}
Power is calculated using the \emph{t} distribution with non-centrality parameter \eqn{d/se}.
}
\examples{
# Two-level model
paras <- study_parameters(n1 = 11,
                          n2 = 40,
                          T_end = 10,
                          icc_pre_subject = 0.5,
                          var_ratio = 0.02,
                          cohend = -0.8)

get_power(paras)

# With missing data
paras <- study_parameters(n1 = 11,
                          n2 = 40,
                          T_end = 10,
                          icc_pre_subject = 0.5,
                          var_ratio = 0.02,
                          dropout = dropout_weibull(0.3, 2),
                          cohend = -0.8)


get_power(paras)


# Three-level model
paras <- study_parameters(n1 = 11,
                          n2 = 10,
                          n3 = 5,
                          T_end = 10,
                          icc_pre_subject = 0.5,
                          icc_pre_cluster = 0,
                          icc_slope = 0.05,
                          var_ratio = 0.02,
                          cohend = -0.8)

get_power(paras)

# With missing data
paras <- study_parameters(n1 = 11,
                          n2 = 10,
                          n3 = 5,
                          T_end = 10,
                          icc_pre_subject = 0.5,
                          icc_pre_cluster = 0,
                          icc_slope = 0.05,
                          var_ratio = 0.02,
                          dropout = dropout_weibull(0.3, 2),
                          cohend = -0.8)

get_power(paras)
}
\seealso{
\code{\link{study_parameters}}, \code{\link{simulate.plcp}}, \code{\link{get_power_table}}
}
