% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get_ICC_slope}
\alias{get_ICC_slope}
\title{Calculate the amount of slope variance at the third level}
\usage{
get_ICC_slope(object, ...)
}
\arguments{
\item{object}{An object created by \code{\link{study_parameters}}.}

\item{...}{Optional named arguments.}
}
\value{
Returns the proportion of slope variance at the third level as
a numeric vector.
}
\description{
Calculate the amount of slope variance at the third level
}
\examples{
paras <- study_parameters(n1 = 11,
                          n2 = 10,
                          n3 = 3,
                          T_end = 10,
                          sigma_subject_intercept = 1.2,
                          sigma_subject_slope = 0.2,
                          sigma_cluster_intercept = 0,
                          sigma_cluster_slope = 0.2,
                          sigma_error = 1.2,
                          cohend = -0.8)

get_ICC_slope(paras)
}
