% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-precision.R
\name{plot_precision_fan_chart}
\alias{plot_precision_fan_chart}
\title{Plot Precision Assurance Fan Chart (Multi-Effect Grid Friendly)}
\usage{
plot_precision_fan_chart(
  power_results_list,
  ci_width_target,
  x_effect = NULL,
  facet_by = NULL,
  effect_filters = NULL,
  effect_weights = NULL,
  show_individual_scenarios = FALSE,
  title = NULL,
  subtitle = NULL
)
}
\arguments{
\item{power_results_list}{Named list of brms_inla_power results (for fan chart across scenarios) or a single object.}

\item{ci_width_target}{Numeric; target credible interval width.}

\item{x_effect}{Name of effect grid column for x-axis (default: first detected grid column).}

\item{facet_by}{Optional grid column(s) for faceting.}

\item{effect_filters}{Optional named list for filtering rows, e.g. list(treatment=0).}

\item{effect_weights}{Optional named numeric vector for averaging over grid values.}

\item{show_individual_scenarios}{Logical: overlay all scenario curves if TRUE.}

\item{title, subtitle}{Optional plot labels.}
}
\value{
A ggplot object.
}
\description{
Shows assurance (proportion of runs meeting CI width <= target) across sample size(s) and effect grid.
Optionally overlays the range (fan/ribbon) across multiple scenarios.
}
