% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_tests.R
\name{test_hdx_analyzer}
\alias{test_hdx_analyzer}
\title{HDX-Analyzer model}
\usage{
test_hdx_analyzer(data, significance_level = 0.05)
}
\arguments{
\item{data}{data.table with deuteration curves}

\item{significance_level}{significance level for tests}
}
\value{
This function returns a data table compatible with the function
\code{\link[powerHaDeX]{calculate_hdx_power}}.
}
\description{
This function performs the test based on the simplest linear models for deuteration
curves containing time, state of the protein and the interaction term. Its input
and output are compatible with the function \code{\link[powerHaDeX]{calculate_hdx_power}}.
}
\examples{
theo_spectra_pf_100 <- simulate_theoretical_spectra(sequence = "LVRKDLQN",
                                                    charge = c(3, 5),
                                                    protection_factor = 100,
                                                    times = c(0.167, 5),
                                                    pH = 7.5,
                                                    temperature = 15,
                                                    n_molecules = 500,
                                                    time_step_const = 1,
                                                    use_markov = TRUE)
theo_spectra_pf_200 <- simulate_theoretical_spectra(sequence = "LVRKDLQN",
                                                    charge = c(3, 5),
                                                    protection_factor = 200,
                                                    times = c(0.167, 5),
                                                    pH = 7.5,
                                                    temperature = 15,
                                                    n_molecules = 500,
                                                    time_step_const = 1,
                                                    use_markov = TRUE)

theo_spectra_two_states <- rbind(theo_spectra_pf_100, theo_spectra_pf_200)

deut_curves_p_states <- get_noisy_deuteration_curves(theo_spectra_two_states,
                                                     n_replicates = 4,
                                                     n_experiments = 1,
                                                     reference = 100)[[1]][[1]]
test_hdx_analyzer(deut_curves_p_states)

}
\references{
Liu, Sanmin et al. (2011). “HDX-analyzer: a novel package for statistical
analysis of protein structure dynamics”. In:BMC bioinformatics12.1, pp. 1–10.
}
\seealso{
Other tests:

- \code{\link[powerHaDeX]{test_houde}}

- \code{\link[powerHaDeX]{test_memhdx_model}}

-\code{\link[powerHaDeX]{test_semiparametric}}

Or \code{\link[powerHaDeX]{calculate_hdx_power}} for estimation of power
of tests for differences in deuteration levels.
}
