% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runif_rs.R
\name{runif_rs}
\alias{runif_rs}
\title{Random Variable From a Uniform Distribution}
\usage{
runif_rs(n = 10, min = 0, max = 1, pmean = 0, psd = 1)
}
\arguments{
\item{n}{The number of random numbers
to generate.}

\item{min}{min for runif.}

\item{max}{max for runif.}

\item{pmean}{Population mean.}

\item{psd}{Population standard
deviation.}
}
\value{
A vector of the generated random numbers.
}
\description{
Generate random numbers
from a uniform distribution, with
user-specified population mean and
standard deviation.
}
\details{
First, the user specifies
the parameters, min and max, and the
desired population mean and standard
deviation. Then the random numbers
will be generated and rescaled with
the desired population mean and
standard.
}
\examples{
set.seed(90870962)
x <- runif_rs(n = 5000,
              min = 2,
              max = 4,
              pmean = 3,
              psd = 1)
mean(x)
sd(x)
hist(x)

}
