% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reserved_variables.R
\name{reserved_variables}
\alias{reserved_variables}
\alias{reserved_variables.default}
\alias{reserved_variables.draws_matrix}
\alias{reserved_variables.draws_array}
\alias{reserved_variables.draws_df}
\alias{reserved_variables.draws_list}
\alias{reserved_variables.draws_rvars}
\title{Reserved variables}
\usage{
reserved_variables(x, ...)

\method{reserved_variables}{default}(x, ...)

\method{reserved_variables}{draws_matrix}(x, ...)

\method{reserved_variables}{draws_array}(x, ...)

\method{reserved_variables}{draws_df}(x, ...)

\method{reserved_variables}{draws_list}(x, ...)

\method{reserved_variables}{draws_rvars}(x, ...)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\value{
A character vector of reserved variables used in \code{x}.
}
\description{
Get names of reserved variables from objects in the \pkg{posterior} package.
}
\details{
\code{reserved_variables()} returns the names of reserved variables in use by
an object.

The following variables names are currently reserved for special use cases
in all \code{\link{draws}} formats:
\itemize{
\item \code{.log_weight}: Log weights per draw (see \code{\link{weight_draws}}).
}

Further, specific for the \code{\link{draws_df}} format, there are three additional
reserved variables:
\itemize{
\item \code{.chain}: Chain index per draw
\item \code{.iteration}: Iteration index within each chain
\item \code{.draw}: Draw index across chains
}

More reserved variables may be added in the future.
}
\examples{

x <- example_draws()
reserved_variables(x)

# if we add weights, the `.log_weight` reserved variable is used
x <- weight_draws(x, rexp(ndraws(x)))
reserved_variables(x)

}
