% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActCosinor2.R
\name{ActCosinor2}
\alias{ActCosinor2}
\title{Cosinor Model for Circadian Rhythmicity}
\usage{
ActCosinor2(x, window = 1, n1440 = 1440)
}
\arguments{
\item{x}{\code{vector} vector of dimension n*1440 which reprsents n days of 1440 minute activity data}

\item{window}{The calculation needs the window size of the data. E.g window = 1 means each epoch is in one-minute window.}

\item{n1440, }{the number of points of a day. Default is 1440 for the minute-level data.}
}
\value{
A list with elements
\item{mes}{MESOR which is short for midline statistics of rhythm, which is a rhythm adjusted mean. This represents mean activity level.}
\item{amp}{amplitude, a measure of half the extend of predictable variation within a cycle. This represents the highest activity one can achieve.}
\item{acro}{acrophase, a meaure of the time of the overall high values recurring in each cycle. Here it has a unit of radian. This represents time to reach the peak.}
\item{acrotime}{acrophase in the unit of the time (hours)}
\item{ndays}{Number of days modeled}
}
\description{
A parametric approach to study circadian rhythmicity assuming cosinor shape.
}
\references{
Cornelissen, G. Cosinor-based rhythmometry. Theor Biol Med Model 11, 16 (2014). https://doi.org/10.1186/1742-4682-11-16
}
