% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double_ML.R
\name{double_ML}
\alias{double_ML}
\title{Post double selection.}
\usage{
double_ML(X, Y, W, method = c("glmnet", "randomforest", "nn", "ols",
  "custom"), show.progress = TRUE, specify.own = NULL, k.fld = 2,
  simulations = 100, validate.inputs = TRUE, seed.use = 1071, ...)
}
\arguments{
\item{X}{A matrix of covariates (must be all numeric)}

\item{Y}{A vector of the target variable, of same length as the number of rows of Y, must be numeric}

\item{W}{A vector of the treatment variable, of same length as the number of rows of X, must be numeric}

\item{method}{A selection of methods to use when doing post double selection.}

\item{show.progress}{Whether to display the simulation progress, defaults to TRUE.}

\item{specify.own}{Allows the user to supply the method to calculate \eqn{\hat{W}} and \eqn{\hat{Y}}, please refer to \link[postDoubleR]{custom_helper}}

\item{k.fld}{How many fold crossfitting to use, defaults to 2.}

\item{simulations}{How many simulations to use for the final result.}

\item{validate.inputs}{A safety measure indicating whether the types of inputs should be checked, defaults to TRUE (disabled for custom methods).}

\item{seed.use}{The seed to use for simulations, defaults to 1071.}

\item{...}{Other arguments to be passed on, see \link[postDoubleR]{rf_helper}, \link[postDoubleR]{glmnet_helper} and \link[postDoubleR]{ols_helper} for details.}
}
\value{
An object of class "ML_Treatment_Effects" that can be further manipulated (ie there is a plot method implemented).
}
\description{
Provides a convenient function to calculate the double ML estimated debiased treatment effect \eqn{\theta}.
}
\details{
Custom functions are currently implemented through a function called custom_generator. For these custom functions, refer to that function and usage examples.
}
\examples{

  n = 2000; p = 10
  X = matrix(rnorm(n*p), n, p)
  W = rbinom(n, 1, 0.4 + 0.2 * (X[,1] > 0))
  Y = pmax(X[,1], 0) * W + X[,2] + pmin(X[,3], 0) + rnorm(n)

double_ML(X, Y, W, method = "glmnet",
              k.fld = 2, simulations = 5,
              lambda.set.Y = 1,
              lambda.set.W = 1,
               Z.trans = F)


}
