% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age.R
\name{check_age}
\alias{check_age}
\title{Validity Checks for Age Labels}
\usage{
check_age(x, complete = FALSE, unique = FALSE, zero = FALSE, open = FALSE)
}
\arguments{
\item{x}{A vector of age labels.}

\item{complete}{If \code{TRUE},
test whether \code{x} has gaps.}

\item{unique}{If \code{TRUE},
test whether \code{x} has duplicates.}

\item{zero}{If \code{TRUE},
test whether youngest age group in
\code{x} starts at 0.}

\item{open}{If \code{TRUE},
test whether oldest age group in \code{x}
is open.}
}
\value{
\code{TRUE}, invisibly, or raises an
error if a test fails.
}
\description{
Check that age labels can be parsed and,
optionally, whether the labels are
complete, unique, start at zero,
and end with an open age group.
}
\details{
By default, \code{check_age()} only tests whether
a set of labels can be parsed as single-year,
five-year, or life table age groups.
(See \code{\link[=age_group_type]{age_group_type()}} for more on the three
types of age group.) However, it can
also apply the following tests:
\itemize{
\item \code{complete}. Whether \code{x} includes
all intermediate age groups, with no gaps.
For instance, the labels \code{c("10-14", "15-19", "5-9")}
are complete, while the labels\code{c("15-19", "5-9")}
are not (because they are missing \code{"10-14"}.)
\item \code{unique}. Whether \code{x} has duplicated labels.
\item \code{zero}. Whether the youngest age group in \code{x} starts
at age 0, ie whether it includes \code{"0"} or \code{"0-4"}.
\item \code{open}. Whether the oldest age group in \code{x} has an "open"
age group, such as \code{"100+"} or \code{"65+"}, that has no
upper limit.
}
}
\examples{
try(
  check_age(c("10-14", "0-4", "15+"),
            complete = TRUE)  
)

try(
  check_age(c("10-14", "5-9", "0-4", "5-9", "15+"),
            unique = TRUE)
)

try(
  check_age(c("10-14", "5-9", "15+"),
            zero = TRUE)
)

try(
  check_age(c("10-14", "0-4", "5-9"),
            open = TRUE)
)
}
\seealso{
\itemize{
\item \code{\link[=reformat_age]{reformat_age()}} to convert age labels to
the format used by \strong{poputils}.
}
}
