% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_rmse.R
\name{pp_rmse}
\alias{pp_rmse}
\title{RMSE}
\usage{
pp_rmse(.target, source, sid, spop, tpop, title)
}
\arguments{
\item{.target}{an object of class \code{sf}}

\item{source}{an object of class \code{sf}}

\item{sid}{source id}

\item{spop}{source population}

\item{tpop}{target population}

\item{title}{scatterplot title \code{string}}
}
\value{
a list including rmse, mae, linear model details and correlation coefficient
}
\description{
RMSE
}
\examples{
# read lib data
data('source')
data('target')

# areal weighted interpolation - awi
awi <- pp_estimate(target, source = source, sid = sid, spop = pop,
    method = awi)

# volume weighted interpolation - vwi
vwi <- pp_estimate(target, source = source, sid = sid, spop = pop,
    method = vwi, volume = floors)

# awi - rmse
pp_rmse(awi, source = source, sid = sid, spop = pop, tpop = pp_est,
    title ='awi')

# vwi - rmse
pp_rmse(vwi, source = source, sid = sid, spop = pop, tpop = pp_est,
    title ='vwi')

}
