#' PoolFstat
#'
#' Computing F-Statistics from Pool-Seq Data
#'
#' @docType package
#' @name poolfstat
#' @exportClass pooldata
#' @import utils
#' @import methods
#' @import foreach
#' @import doParallel
#' @import parallel
#' @import stats
#' @importFrom utils read.table write.table
#' @importFrom methods is new validObject
#' @importFrom foreach foreach getDoParWorkers
#' @importFrom parallel detectCores
#' @importFrom doParallel registerDoParallel
#' @importFrom stats quantile
#' @importFrom Rcpp evalCpp
#' @useDynLib poolfstat
#' @description Functions for the computation of F-statistics from Pool-Seq data in population genomics studies. The package also includes several utilities to manipulate Pool-Seq data stored in standard format ('vcf' or 'rsync' files generated by the the 'PoPoolation' software) and perform conversion to alternative format (as used in the 'BayPass' and 'SelEstim' software).
NULL