% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_import.R
\name{checkMissing}
\alias{checkMissing}
\title{Remove sites with missing data}
\usage{
checkMissing(info, major, minor, rMajor, rMinor, coverage)
}
\arguments{
\item{info}{is a matrix containing information about the dataset. This matrix
might contain several columns including one with the reference contig
(chromosome), the position of the SNP in the reference contig and the
reference character of the SNP. Note that each row of the matrix should be
a different SNP and each column a different type of information.}

\item{major}{is a matrix with the reference character of the major allele.
Each column of the matrix should be a different population and each row a
different SNP.}

\item{minor}{is a matrix with the reference character of the minor allele.
Each column of the matrix should be a different population and each row a
different SNP.}

\item{rMajor}{is a matrix with the number of major allele reads. Each column
of the matrix should be a different population and each row a different
SNP.}

\item{rMinor}{is a matrix with the number of minor allele reads. Each column
of the matrix should be a different population and each row a different
SNP.}

\item{coverage}{is a matrix with the total number of reads i.e. the depth of
coverage. Each column of the matrix should be a different population and
each row a different SNP.}
}
\value{
a list with the following elements:

\item{info}{a matrix with the general information about the dataset. Each
row of this matrix corresponds to a different site.}

\item{major}{a matrix with the reference character of the major allele.
Each column of this matrix corresponds to a different population and each
row to a different site.}

\item{minor}{a matrix with the reference character of the minor allele.
Each column of this matrix corresponds to a different population and each
row to a different site.}

\item{rMajor}{a matrix with the number of major-allele reads. Each row of
this matrix is a different site and each column a different population.}

\item{rMinor}{a matrix with the number of minor-allele reads. Each row of
this matrix is a different site and each column a different population.}

\item{coverage}{a matrix with the total coverage. Each row of this matrix
is a different site and each column a different population.}

Each of those matrices is similar to the corresponding input but without
any sites where any of the populations has an "N" as the reference
character for the major allele.
}
\description{
This functions checks if there is any population with an "N" as the reference
character for the major allele.
}
\details{
This verification is performed for all the populations included in the
dataset. Any site where this verification fails for any of the populations is
removed from the dataset. More precisely, if a single population has an "N"
as the reference character of their major allele, then that site is removed
from the data for all the populations.
}
\keyword{internal}
