% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_import.R
\name{checkCoverage}
\alias{checkCoverage}
\title{Remove sites with incorrect depths of coverage}
\usage{
checkCoverage(nPops, info, major, minor, rMajor, rMinor, coverage)
}
\arguments{
\item{nPops}{is an integer indicating the total number of different
populations in the dataset.}

\item{info}{is a matrix containing information about the dataset. This matrix
might contain several columns including one with the reference contig
(chromosome), the position of the SNP in the reference contig and the
reference character of the SNP. Note that each row of the matrix should be
a different SNP and each column a different type of information.}

\item{major}{is a matrix with the reference character of the major allele.
Each column of the matrix should be a different population and each row a
different SNP.}

\item{minor}{is a matrix with the reference character of the minor allele.
Each column of the matrix should be a different population and each row a
different SNP.}

\item{rMajor}{is a matrix with the number of major allele reads. Each column
of the matrix should be a different population and each row a different
SNP.}

\item{rMinor}{is a matrix with the number of minor allele reads. Each column
of the matrix should be a different population and each row a different
SNP.}

\item{coverage}{is a matrix with the total number of reads i.e. the depth of
coverage. Each column of the matrix should be a different population and
each row a different SNP.}
}
\value{
a list with the following elements:

\item{info}{a matrix with the general information about the dataset. Each
row of this matrix corresponds to a different site.}

\item{major}{a matrix with the reference character of the major allele.
Each column of this matrix corresponds to a different population and each
row to a different site.}

\item{minor}{a matrix with the reference character of the minor allele.
Each column of this matrix corresponds to a different population and each
row to a different site.}

\item{rMajor}{a matrix with the number of major-allele reads. Each row of
this matrix is a different site and each column a different population.}

\item{rMinor}{a matrix with the number of minor-allele reads. Each row of
this matrix is a different site and each column a different population.}

\item{coverage}{a matrix with the total coverage. Each row of this matrix
is a different site and each column a different population.}

Each of those matrices is similar to the corresponding input but without
any sites where the total depth of coverage does not match the sum of the
major and minor allele reads.
}
\description{
This functions checks if the sum of the number of major and minor allele
reads of a given population is equal to the total depth of coverage of that
population.
}
\details{
This verification is performed for all the populations included in the
dataset. Any site where this verification fails for any of the populations is
removed from the dataset. More precisely, if the sum of the number of major
and minor allele reads of one population is not equal to the coverage of that
population, then that site is removed from the data for all the populations.
}
\keyword{internal}
