% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbplyr.R
\name{dplyr-db-methods}
\alias{dplyr-db-methods}
\alias{copy_to.Pool}
\alias{tbl.Pool}
\alias{db_analyze.Pool}
\alias{db_begin.Pool}
\alias{db_commit.Pool}
\alias{db_create_index.Pool}
\alias{db_create_indexes.Pool}
\alias{db_create_table.Pool}
\alias{db_data_type.Pool}
\alias{db_desc.Pool}
\alias{db_drop_table.Pool}
\alias{db_explain.Pool}
\alias{db_has_table.Pool}
\alias{db_insert_into.Pool}
\alias{db_list_tables.Pool}
\alias{db_query_fields.Pool}
\alias{db_query_rows.Pool}
\alias{db_rollback.Pool}
\alias{db_save_query.Pool}
\alias{db_write_table.Pool}
\alias{sql_escape_ident.Pool}
\alias{sql_escape_string.Pool}
\alias{sql_join.Pool}
\alias{sql_select.Pool}
\alias{sql_semi_join.Pool}
\alias{sql_subquery.Pool}
\alias{sql_translate_env.Pool}
\alias{db_collect.Pool}
\alias{db_compute.Pool}
\alias{db_sql_render.Pool}
\alias{sql_escape_logical.Pool}
\title{DBIConnection methods from dplyr and dbplyr}
\usage{
copy_to.Pool(
  dest,
  df,
  name = deparse(substitute(df)),
  overwrite = FALSE,
  temporary = TRUE,
  ...
)

tbl.Pool(src, from, ...)

db_analyze.Pool(con, table, ...)

db_begin.Pool(con, ...)

db_commit.Pool(con, ...)

db_create_index.Pool(con, table, columns, name = NULL, unique = FALSE, ...)

db_create_indexes.Pool(con, table, indexes = NULL, unique = FALSE, ...)

db_create_table.Pool(con, table, types, temporary = FALSE, ...)

db_data_type.Pool(con, fields)

db_desc.Pool(x)

db_drop_table.Pool(con, table, force = FALSE, ...)

db_explain.Pool(con, sql, ...)

db_has_table.Pool(con, table)

db_insert_into.Pool(con, table, values, ...)

db_list_tables.Pool(con)

db_query_fields.Pool(con, sql, ...)

db_query_rows.Pool(con, sql, ...)

db_rollback.Pool(con, ...)

db_save_query.Pool(con, sql, name, temporary = TRUE, ...)

db_write_table.Pool(con, table, types, values, temporary = FALSE, ...)

sql_escape_ident.Pool(con, x)

sql_escape_string.Pool(con, x)

sql_join.Pool(con, x, y, vars, type = "inner", by = NULL, ...)

sql_select.Pool(
  con,
  select,
  from,
  where = NULL,
  group_by = NULL,
  having = NULL,
  order_by = NULL,
  limit = NULL,
  distinct = FALSE,
  ...
)

sql_semi_join.Pool(con, x, y, anti = FALSE, by = NULL, ...)

sql_subquery.Pool(con, from, name = random_table_name(), ...)

sql_translate_env.Pool(con)

db_collect.Pool(con, sql, n = -1, warn_incomplete = TRUE, ...)

db_compute.Pool(
  con,
  table,
  sql,
  temporary = TRUE,
  unique_indexes = list(),
  indexes = list(),
  ...
)

db_sql_render.Pool(con, sql, ...)

sql_escape_logical.Pool(con, x)
}
\arguments{
\item{dest, df, name, overwrite, temporary, ..., src, from, con, table, columns, unique, indexes, types, fields, x, force, sql, values, y, vars, type, by, select, where, group_by, having, order_by, limit, distinct, anti, n, warn_incomplete, unique_indexes}{See original documentation.}
}
\description{
Pool object wrappers around DBIConnection methods, whose generics are
defined either in \code{dplyr} or in \code{dbplyr}.
For the original documentation, see
\href{https://dplyr.tidyverse.org/reference/index.html}{dplyr's reference page}
and \href{https://dbplyr.tidyverse.org/reference/index.html}{dbplyr's reference page}.
}
\examples{
if (requireNamespace("RSQLite", quietly = TRUE)) {
  library(dplyr)

  db <- tempfile()
  pool <- dbPool(RSQLite::SQLite(), dbname = db)

  # copy a table into the database
  copy_to(pool, mtcars, "mtcars", temporary = FALSE)

  # retrieve a table
  mtcars_db <- tbl(pool, "mtcars")
  mtcars_db
  mtcars_db \%>\% select(mpg, cyl, disp)
  mtcars_db \%>\% filter(cyl == 6) \%>\% collect()

  poolClose(pool)
} else {
  message("Please install the 'RSQLite' package to run this example")
}
}
