% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial-class.R
\docType{class}
\name{pompp_initial-class}
\alias{pompp_initial-class}
\alias{names,pompp_initial-method}
\alias{$,pompp_initial-method}
\alias{+,pompp_initial,ANY-method}
\alias{+,list,pompp_initial-method}
\alias{+,pompp_initial,list-method}
\alias{*,pompp_initial,numeric-method}
\alias{*,numeric,pompp_initial-method}
\alias{show,pompp_initial-method}
\alias{print,pompp_initial-method}
\alias{print.pompp_initial}
\title{Class for the initial values for the MCMC for the pompp package}
\usage{
\S4method{names}{pompp_initial}(x)

\S4method{$}{pompp_initial}(x, name)

\S4method{+}{pompp_initial,ANY}(e1, e2)

\S4method{+}{list,pompp_initial}(e1, e2)

\S4method{+}{pompp_initial,list}(e1, e2)

\S4method{*}{pompp_initial,numeric}(e1, e2)

\S4method{*}{numeric,pompp_initial}(e1, e2)

\S4method{show}{pompp_initial}(object)

\S4method{print}{pompp_initial}(x, ...)

\method{print}{pompp_initial}(x, ...)
}
\arguments{
\item{x}{The pompp_initial object.}

\item{name}{The requested slot.}

\item{e1}{A pompp_initial object.}

\item{e2}{Another pompp_initial object or a list with pompp_initial
objects for \strong{+} and a positive integer for \strong{*}. e1 and e2
can be switched (+ and * are commutative).}

\item{object}{A pompp_initial object.}

\item{...}{Currently unused.}
}
\value{
\strong{\code{names}}: A character vector with the initialized
parameter names.

\strong{\code{`$`}}: The requested initial value (in case of
LambdaStar) or values (in case of Beta or Delta).

\strong{\code{+}}: A list with the objects. Useful to start the
\code{fit_pompp} function, as it requires a list of initial values.

\strong{\code{*}}: A list with \code{e2} random initial values.

\strong{\code{show}} and \strong{\code{print}}: The invisible object.
}
\description{
Class for the initial values for the MCMC for the pompp package
}
\section{Fields}{

\describe{
\item{\code{beta}}{Initial values for beta.}

\item{\code{delta}}{Initial values for delta.}

\item{\code{lambdaStar}}{Initial values for lambdaStar.}

\item{\code{tag}}{Indicates the source of the initial values.}
}}

