% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sannbox.R
\name{sannbox}
\alias{sannbox}
\title{Simulated annealing with box constraints.}
\usage{
sannbox(par, fn, control = list(), ...)
}
\arguments{
\item{par}{Initial values for the parameters to be optimized over.}

\item{fn}{A function to be minimized, with first argument the vector of
parameters over which minimization is to take place.  It should return a
scalar result.}

\item{control}{A named list of control parameters.  See \sQuote{Details}.}

\item{\dots}{ignored.}
}
\value{
\code{sannbox} returns a list with components:
\describe{
\item{counts}{
two-element integer vector.
The first number gives the number of calls made to \code{fn}.
The second number is provided for compatibility with \code{\link[stats]{optim}} and will always be NA.
}
\item{convergence}{
provided for compatibility with \code{\link[stats]{optim}};
will always be 0.
}
\item{final.params}{last tried value of \code{par}.}
\item{final.value}{value of \code{fn} corresponding to
\code{final.params}.}
\item{par}{best tried value of \code{par}.}
\item{value}{value of \code{fn} corresponding to \code{par}.} }
}
\description{
A straightforward implementation of simulated annealing with box constraints.
}
\details{
The \code{control} argument is a list that can supply any of the following components:
\describe{
\item{trace}{ Non-negative integer.
If positive, tracing information on the progress of the optimization is
produced.  Higher values may produce more tracing information.  }
\item{fnscale}{ An overall scaling to be applied to the value of
\code{fn} during optimization.  If negative, turns the problem into a
maximization problem.  Optimization is performed on \code{fn(par)/fnscale}.}
\item{parscale}{ A vector of scaling values for the parameters.
Optimization is performed on \code{par/parscale} and these should be
comparable in the sense that a unit change in any element produces about a
unit change in the scaled value.  }
\item{maxit}{ The total number of function evaluations: there is no
other stopping criterion.  Defaults to \code{10000}.  }
\item{temp}{ starting temperature for the cooling
schedule.  Defaults to \code{1}.  }
\item{tmax}{ number of function evaluations at each temperature.
Defaults to \code{10}.  }
\item{candidate.dist}{ function to randomly select a new candidate
parameter vector.  This should be a function with three arguments, the
first being the current parameter vector, the second the temperature, and
the third the parameter scaling.  By default, \code{candidate.dist} is
\preformatted{function(par,temp,scale)
                rnorm(n=length(par),mean=par,sd=scale*temp).} }
\item{sched}{ cooling schedule.  A function of a three arguments giving the
temperature as a function of iteration number and the control parameters
\code{temp} and \code{tmax}.
By default, \code{sched} is
\preformatted{function(k,temp,tmax) temp/log(((k-1)\%/\%tmax)*tmax+exp(1)).}
Alternatively, one can supply a numeric vector of temperatures.
This must be of length at least \code{maxit}. }
\item{lower,upper}{ optional
numeric vectors.  These describe the lower and upper box constraints,
respectively.  Each can be specified either as a single scalar (common to
all parameters) or as a vector of the same length as \code{par}.  By
default, \code{lower=-Inf} and \code{upper=Inf}, i.e., there are no
constraints.} }
}
\seealso{
\link[=traj_match]{trajectory matching}, \link[=probe_match]{probe matching}, \link[=spect_match]{spectrum matching}, \link[=nlf]{nonlinear forecasting}.
}
\author{
Daniel Reuman, Aaron A. King
}
\keyword{optimize}
