% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow.R
\name{flow}
\alias{flow}
\alias{flow,missing-method}
\alias{flow,ANY-method}
\alias{flow,pomp-method}
\title{flow workhorse}
\usage{
\S4method{flow}{pomp}(
  object,
  x0,
  t0 = timezero(object),
  times = time(object),
  params = coef(object),
  ...,
  verbose = getOption("verbose", FALSE)
)
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or of a class that extends \sQuote{pomp}.
This will typically be the output of \code{pomp}, \code{simulate}, or one of the \pkg{pomp} inference algorithms.}

\item{x0}{an array with dimensions \code{nvar} x \code{nrep} giving the initial conditions of the trajectories to be computed.}

\item{t0}{the time at which the initial conditions are assumed to hold.
By default, this is the zero-time (see \code{\link{timezero}}).}

\item{times}{a numeric vector (length \code{ntimes}) containing times at which the itineraries are desired.
These must be in non-decreasing order with \code{times[1]>t0}.
By default, this is the full set of observation times (see \code{\link{time}}).}

\item{params}{a \code{npar} x \code{nrep} matrix of parameters.
Each column is treated as an independent parameter set, in correspondence with the corresponding column of \code{x}.}

\item{...}{Additional arguments are passed to the ODE integrator (if the skeleton is a vectorfield) and are ignored if it is a map.
See \code{\link[deSolve]{ode}} for a description of the additional arguments accepted by the ODE integrator.
By default, this is the parameter vector stored in \code{object} (see \code{\link[pomp]{coef}}).}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\value{
\code{flow} returns an array of dimensions \code{nvar} x \code{nrep} x \code{ntimes}.
If \code{x} is the returned matrix, \code{x[i,j,k]} is the i-th component of the state vector at time \code{times[k]} given parameters \code{params[,j]}.
}
\description{
Compute the flow generated by a deterministic vectorfield or map.
}
\details{
In the case of a discrete-time system (map), \code{flow} iterates the map to yield trajectories of the system.
In the case of a continuous-time system (vectorfield), \code{flow} uses the numerical solvers in \pkg{\link[deSolve]{deSolve}} to integrate the vectorfield starting from given initial conditions.
}
\seealso{
More on \pkg{pomp} workhorse functions: 
\code{\link{dinit}()},
\code{\link{dmeasure}()},
\code{\link{dprior}()},
\code{\link{dprocess}()},
\code{\link{emeasure}()},
\code{\link{partrans}()},
\code{\link{pomp-package}},
\code{\link{rinit}()},
\code{\link{rmeasure}()},
\code{\link{rprior}()},
\code{\link{rprocess}()},
\code{\link{skeleton}()},
\code{\link{vmeasure}()},
\code{\link{workhorses}}

More on methods for deterministic process models: 
\code{\link{skeleton}()},
\code{\link{skeleton_spec}},
\code{\link{traj_match}},
\code{\link{trajectory}()}
}
\concept{deterministic methods}
\concept{extending the pomp package}
\concept{low-level interface}
\concept{pomp workhorses}
