% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kf.R
\name{kalmanFilter}
\alias{kalmanFilter}
\title{Kalman filter}
\usage{
kalmanFilter(object, X0, A, Q, C, R, tol = 1e-06)
}
\arguments{
\item{object}{a pomp object containing data;}

\item{X0}{length-m vector containing initial state.
This is assumed known without uncertainty.}

\item{A}{\eqn{m\times m}{m x m} latent state-process transition matrix.
\eqn{E[X(t+1) | X(t)] = A.X(t)}.}

\item{Q}{\eqn{m\times m}{m x m} latent state-process covariance matrix.
\eqn{Var[X(t+1) | X(t)] = Q}}

\item{C}{\eqn{n\times m}{n x m} link matrix.
\eqn{E[Y(t) | X(t)] = C.X(t)}.}

\item{R}{\eqn{n\times n}{n x n} observation process covariance matrix.
\eqn{Var[Y(t) | X(t)] = R}}

\item{tol}{numeric;
the tolerance to be used in computing matrix pseudoinverses via singular-value decomposition.
Singular values smaller than \code{tol} are set to zero.}
}
\value{
A named list containing the following elements:
\describe{
  \item{object}{the \sQuote{pomp} object}
  \item{A, Q, C, R}{as in the call}
  \item{filter.mean}{\eqn{E[X(t)|y^*(1),\dots,y^*(t)]}}
  \item{pred.mean}{\eqn{E[X(t)|y^*(1),\dots,y^*(t-1)]}}
  \item{forecast}{\eqn{E[Y(t)|y^*(1),\dots,y^*(t-1)]}}
  \item{cond.logLik}{\eqn{f(y^*(t)|y^*(1),\dots,y^*(t-1))}}
  \item{logLik}{\eqn{f(y^*(1),\dots,y^*(T))}}
}
}
\description{
The basic Kalman filter for multivariate, linear, Gaussian processes.
}
\details{
If the latent state is \eqn{X}, the observed variable is \eqn{Y},
\eqn{X(t) \in R^m}, \eqn{Y(t) \in R^n}, and
\deqn{X(t) ~ MultivariateNormal(A X(t-1), Q)}
\deqn{Y(t) ~ MultivariateNormal(C X(t), R)}
Then the Kalman filter computes the exact likelihood of \eqn{Y} given
\eqn{A}, \eqn{C}, \eqn{Q}, and \eqn{R}.
}
\examples{
\dontrun{

  if (require(dplyr)) {

    gompertz() -> po

    po \%>\%
      as.data.frame() \%>\%
      mutate(
        logY=log(Y)
      ) \%>\%
      select(time,logY) \%>\%
      pomp(times="time",t0=0) \%>\%
      kalmanFilter(
        X0=c(logX=0),
        A=matrix(exp(-0.1),1,1),
        Q=matrix(0.01,1,1),
        C=matrix(1,1,1),
        R=matrix(0.01,1,1)
      ) -> kf

    po \%>\%
      pfilter(Np=1000) -> pf

    kf$logLik
    logLik(pf) + sum(log(obs(pf)))
    
  }
}
}
\seealso{
\code{\link{enkf}}, \code{\link{eakf}}
}
\concept{Kalman filter}
