% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_traj.R
\name{filter.traj}
\alias{filter.traj}
\alias{filter.traj,ANY-method}
\alias{filter.traj,missing-method}
\alias{filter.traj,pfilterd_pomp-method}
\alias{filter.traj,pfilterList-method}
\alias{filter.traj,pmcmcd_pomp-method}
\alias{filter.traj,pmcmcList-method}
\title{Filtering trajectories}
\usage{
\S4method{filter.traj}{pfilterd_pomp}(object, vars, ...)

\S4method{filter.traj}{pfilterList}(object, vars, ...)

\S4method{filter.traj}{pmcmcd_pomp}(object, vars, ...)

\S4method{filter.traj}{pmcmcList}(object, vars, ...)
}
\arguments{
\item{object}{result of a filtering computation}

\item{vars}{optional character; names of variables}

\item{...}{ignored}
}
\description{
Drawing from the smoothing distribution
}
\details{
The smoothing distribution is the distribution of
\deqn{X(t_k) | Y(t_1)=y^*_1, \dots, Y(t_n)=y^*_n,}{Xk | Y1=y1*, \dots, Yn=yn*,}
where \eqn{X(t_k)}{Xk} is the latent state process and \eqn{Y(t_k)}{Yk} is the observable process at time \eqn{t_k}{tk}, and \eqn{n} is the number of observations.

To draw samples from this distribution, one can run a number of independent particle filter (\code{\link{pfilter}}) operations, sampling the full trajectory of \emph{one} randomly-drawn particle from each one.
One should view these as \emph{weighted} samples from the smoothing distribution, where the weights are the \emph{likelihoods} returned by each of the \code{\link{pfilter}} computations.

One accomplishes this by setting \code{filter.traj = TRUE} in each \code{\link{pfilter}} computation and extracting the trajectory using the \code{filter.traj} command.

In particle MCMC (\code{\link{pmcmc}}), the tracking of an individual trajectory is performed automatically.
}
\seealso{
More on particle-filter based methods in \pkg{pomp}: 
\code{\link{bsmc2}()},
\code{\link{cond.logLik}()},
\code{\link{eff.sample.size}()},
\code{\link{filter.mean}()},
\code{\link{kalman}},
\code{\link{mif2}()},
\code{\link{pfilter}()},
\code{\link{pmcmc}()},
\code{\link{pred.mean}()},
\code{\link{pred.var}()},
\code{\link{saved.states}()},
\code{\link{wpfilter}()}
}
\concept{particle_filter_methods}
