% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probe_match.R
\name{probe.match}
\alias{probe.match}
\alias{probe_objfun}
\alias{probe_objfun,missing-method}
\alias{probe_objfun,ANY-method}
\alias{probe_objfun-data.frame}
\alias{probe_objfun,data.frame-method}
\alias{probe_objfun-pomp}
\alias{probe_objfun,pomp-method}
\alias{probe_objfun-probed_pomp}
\alias{probe_objfun,probed_pomp-method}
\alias{probe_objfun-probe_match_objfun}
\alias{probe_objfun,probe_match_objfun-method}
\title{Probe matching}
\usage{
\S4method{probe_objfun}{data.frame}(
  data,
  est = character(0),
  fail.value = NA,
  probes,
  nsim,
  seed = NULL,
  params,
  rinit,
  rprocess,
  rmeasure,
  partrans,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{probe_objfun}{pomp}(
  data,
  est = character(0),
  fail.value = NA,
  probes,
  nsim,
  seed = NULL,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{probe_objfun}{probed_pomp}(
  data,
  est = character(0),
  fail.value = NA,
  probes,
  nsim,
  seed = NULL,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{probe_objfun}{probe_match_objfun}(
  data,
  est,
  fail.value,
  seed = NULL,
  ...,
  verbose = getOption("verbose", FALSE)
)
}
\arguments{
\item{data}{either a data frame holding the time series data,
or an object of class \sQuote{pomp},
i.e., the output of another \pkg{pomp} calculation.}

\item{est}{character vector; the names of parameters to be estimated.}

\item{fail.value}{optional numeric scalar;
if non-\code{NA}, this value is substituted for non-finite values of the objective function.
It should be a large number (i.e., bigger than any legitimate values the objective function is likely to take).}

\item{probes}{a single probe or a list of one or more probes.
A probe is simply a scalar- or vector-valued function of one argument that can be applied to the data array of a \sQuote{pomp}.
A vector-valued probe must always return a vector of the same size.
A number of useful probes are provided with the package:
see \link[=basic_probes]{basic probes}.}

\item{nsim}{the number of model simulations to be computed.}

\item{seed}{integer.
When fitting, it is often best to fix the seed of the random-number generator (RNG).
This is accomplished by setting \code{seed} to an integer.
By default, \code{seed = NULL}, which does not alter the RNG state.}

\item{params}{optional; named numeric vector of parameters.
This will be coerced internally to storage mode \code{double}.}

\item{rinit}{simulator of the initial-state distribution.
This can be furnished either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rinit=NULL} sets the initial-state simulator to its default.
For more information, see \link[=rinit_spec]{?rinit_spec}.}

\item{rprocess}{simulator of the latent state process, specified using one of the \link[=rprocess_spec]{rprocess plugins}.
Setting \code{rprocess=NULL} removes the latent-state simulator.
For more information, \link[=rprocess_spec]{see ?rprocess_spec for the documentation on these plugins}.}

\item{rmeasure}{simulator of the measurement model, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rmeasure=NULL} removes the measurement model simulator.
For more information, see \link[=rmeasure_spec]{?rmeasure_spec}.}

\item{partrans}{optional parameter transformations, constructed using \code{\link{parameter_trans}}.

Many algorithms for parameter estimation search an unconstrained space of parameters.
When working with such an algorithm and a model for which the parameters are constrained, it can be useful to transform parameters.
One should supply the \code{partrans} argument via a call to \code{\link{parameter_trans}}.
For more information, see \link[=parameter_trans]{?parameter_trans}.
Setting \code{partrans=NULL} removes the parameter transformations, i.e., sets them to the identity transformation.}

\item{...}{additional arguments supply new or modify existing model characteristics or components.
See \code{\link{pomp}} for a full list of recognized arguments.

When named arguments not recognized by \code{\link{pomp}} are provided, these are made available to all basic components via the so-called \dfn{userdata} facility.
This allows the user to pass information to the basic components outside of the usual routes of covariates (\code{covar}) and model parameters (\code{params}).
See \link[=userdata]{?userdata} for information on how to use this facility.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\value{
\code{probe_objfun} constructs a stateful objective function for probe matching.
Specifically, \code{probe_objfun} returns an object of class \sQuote{probe_match_objfun}, which is a function suitable for use in an \code{\link{optim}}-like optimizer.
In particular, this function takes a single numeric-vector argument that is assumed to contain the parameters named in \code{est}, in that order.
When called, it will return the negative synthetic log likelihood for the probes specified.
It is a stateful function:
Each time it is called, it will remember the values of the parameters and its estimate of the synthetic likelihood.
}
\description{
Estimation of parameters by maximum synthetic likelihood
}
\details{
In probe-matching, one attempts to minimize the discrepancy between simulated and actual data, as measured by a set of summary statistics called \emph{probes}.
In \pkg{pomp}, this discrepancy is measured using the \dQuote{synthetic likelihood} as defined by Wood (2010).
}
\section{Important Note}{

Since \pkg{pomp} cannot guarantee that the \emph{final} call an optimizer makes to the function is a call \emph{at} the optimum, it cannot guarantee that the parameters stored in the function are the optimal ones.
Therefore, it is a good idea to evaluate the function on the parameters returned by the optimization routine, which will ensure that these parameters are stored.
}

\examples{
\donttest{
  library(magrittr)

  gompertz() -> po
  
  ## A list of probes:
  plist <- list(
    mean=probe.mean("Y",trim=0.1,transform=sqrt),
    sd=probe.sd("Y",transform=sqrt),
    probe.marginal("Y",ref=obs(po)),
    probe.acf("Y",lags=c(1,3,5),type="correlation",transform=sqrt),
    probe.quantile("Y",prob=c(0.25,0.75),na.rm=TRUE)
  )

  ## Construct the probe-matching objective function.
  ## Here, we just want to estimate 'K'.
  po \%>\%
    probe_objfun(probes=plist,nsim=100,seed=5069977,
      est="K") -> f

  ## Any numerical optimizer can be used to minimize 'f'.
  library(subplex)

  subplex(fn=f,par=0.4,control=list(reltol=1e-5)) -> out

  ## Call the objective one last time on the optimal parameters:
  f(out$par)

  ## There are 'plot' and 'summary' methods:
  f \%>\% as("probed_pomp") \%>\% plot()
  f \%>\% summary()

  f \%>\% probe() \%>\% plot()

  ## One can modify the objective function with another call
  ## to 'probe_objfun':

  f \%>\% probe_objfun(est=c("r","K")) -> f1
}
}
\seealso{
\code{\link{optim}} \code{\link[subplex]{subplex}} \code{\link[nloptr]{nloptr}}

Other summary statistics methods: 
\code{\link{abc}()},
\code{\link{basic_probes}},
\code{\link{probe}()},
\code{\link{spect}()}

Other pomp parameter estimation methods: 
\code{\link{abc}()},
\code{\link{bsmc2}()},
\code{\link{kalman}},
\code{\link{mif2}()},
\code{\link{nlf}},
\code{\link{pmcmc}()},
\code{\link{pomp-package}},
\code{\link{spect.match}}
}
\author{
Aaron A. King
}
\concept{pomp parameter estimation methods}
\concept{summary statistics methods}
