% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verhulst.R
\docType{data}
\name{verhulst}
\alias{verhulst}
\title{Verhulst-Pearl model}
\usage{
verhulst(n_0 = 10000, K = 10000, r = 0.9, sigma = 0.4, tau = 0.1,
  dt = 0.01)
}
\arguments{
\item{n_0}{initial condition}

\item{K}{carrying capacity}

\item{r}{intrinsic growth rate}

\item{sigma}{environmental process noise s.d.}

\item{tau}{measurement error s.d.}

\item{dt}{Euler time-step}
}
\value{
A \sQuote{pomp} object containing the model and simulated data.
The following basic components are included in the \sQuote{pomp} object:
\sQuote{rinit}, \sQuote{rprocess}, \sQuote{rmeasure}, \sQuote{dmeasure}, and \sQuote{skeleton}.
}
\description{
The Verhulst-Pearl (logistic) model of population growth.
}
\details{
A stochastic version of the Verhulst-Pearl logistic model.
This evolves in continuous time, according to the stochastic differential equation
\deqn{dn = r\,n\,\left(1-\frac{n}{K}\right)\,dt+\sigma\,n\,dW.}{dn = r n (1-n/K) dt + sigma n dW.}

Numerically, we simulate the stochastic dynamics using an Euler approximation.

The measurements are assumed to be log-normally distributed.
}
\examples{
verhulst() -> po
plot(po)
plot(simulate(po))
pfilter(po,Np=1000) -> pf
logLik(pf)
spy(po)
}
\seealso{
Other pomp examples: \code{\link{blowflies}},
  \code{\link{dacca}}, \code{\link{ebola}},
  \code{\link{gompertz}}, \code{\link{measles}},
  \code{\link{ou2}}, \code{\link{ricker}},
  \code{\link{rw2}}, \code{\link{sir_models}}
}
\concept{pomp examples}
