% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POMDP_file_examples.R
\docType{data}
\name{POMDP_example_files}
\alias{POMDP_example_files}
\title{POMDP Example Files}
\description{
Some POMDP example files are shipped with the package.
}
\details{
Currently, the following POMDP example files are available:
\itemize{
\item \code{"light_maze.POMDP"}: a simple maze introduced in Littman (2009).
\item \code{"shuttle_95.POMDP"}: Transport goods between two space
stations (Chrisman, 1992).
\item \code{"tiger_aaai.POMDP"}: Tiger Problem introduced in Cassandra et al (1994).
}

More files can be found at https://www.pomdp.org/examples/
}
\examples{
dir(system.file("examples/", package = "pomdp"))

model <- read_POMDP(system.file("examples/light_maze.POMDP", 
  package = "pomdp"))
model
}
\references{
Anthony R. Cassandra, Leslie P Kaelbling, and Michael L. Littman (1994).
Acting Optimally in Partially Observable Stochastic Domains.
\emph{In Proceedings of the Twelfth National Conference on Artificial
Intelligence,} pp. 1023-1028.

Lonnie Chrisman (1992), Reinforcement Learning with Perceptual Aliasing: The
\emph{Proceedings of the AAAI Conference on Artificial Intelligence,}
10, AAAI-92.

Michael L. Littman (2009), A tutorial on partially observable Markov decision processes,
\emph{Journal of Mathematical Psychology,} Volume 53, Issue 3, June 2009, Pages 119-125.
\doi{10.1016/j.jmp.2009.01.005}
}
\seealso{
Other POMDP_examples: 
\code{\link{POMDP}()},
\code{\link{RussianTiger}},
\code{\link{Tiger}}
}
\concept{POMDP_examples}
\keyword{datasets}
