% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyCub.iso.R
\name{checkintrfr}
\alias{checkintrfr}
\title{Check the Integral of \eqn{r f_r(r)}}
\usage{
checkintrfr(intrfr, f, ..., center, control = list(), rs = numeric(0L),
  tolerance = control$rel.tol)
}
\arguments{
\item{intrfr}{a \code{function(R, ...)}, which implements the (analytical)
antiderivative of \eqn{r f_r(r)} from 0 to \code{R}. The first argument
must be vectorized but not necessarily named \code{R}.\cr
If \code{intrfr} is missing, it will be approximated numerically via
\code{\link{integrate}(function(r, ...)
r * f(cbind(x0 + r, y0), ...), 0, R, ..., control=control)},
where \code{c(x0, y0)} is the \code{center} of isotropy.
Note that \code{f} will \emph{not} be checked for isotropy.}

\item{f}{a two-dimensional real-valued function.
As its first argument it must take a coordinate matrix, i.e., a
numeric matrix with two columns, and it must return a numeric vector of
length the number of coordinates.}

\item{...}{further arguments for \code{f} or \code{intrfr}.}

\item{center}{numeric vector of length 2, the center of isotropy.}

\item{control}{list of arguments passed to \code{\link{integrate}}, the
quadrature rule used for the line integral along the polygon boundary.}

\item{rs}{numeric vector of upper bounds for which to check the validity of
\code{intrfr}. If it has length 0 (default), no checks are performed.}

\item{tolerance}{of \code{\link{all.equal.numeric}} when comparing
\code{intrfr} results with numerical integration. Defaults to the
relative tolerance used for \code{integrate}.}
}
\value{
The \code{intrfr} function. If it was not supplied, its quadrature
version using \code{integrate} is returned.
}
\description{
This function is auxiliary to \code{\link{polyCub.iso}}.
The (analytical) integral of \eqn{r f_r(r)} from 0 to \eqn{R} is checked
against a numeric approximation using \code{\link{integrate}} for various
values of the upper bound \eqn{R}. A warning is issued if inconsistencies
are found.
}
