% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kwic_class.R, R/enrich_method.R,
%   R/highlight_method.R, R/view_method.R
\docType{class}
\name{kwic-class}
\alias{kwic-class}
\alias{[,kwic,ANY,ANY,ANY-method}
\alias{[,kwic-method}
\alias{show,kwic-method}
\alias{as.data.frame,kwic-method}
\alias{length,kwic-method}
\alias{sample,kwic-method}
\alias{enrich,kwic-method}
\alias{highlight,kwic-method}
\alias{view,kwic-method}
\title{kwic (S4 class)}
\usage{
\S4method{show}{kwic}(object)

\S4method{as.data.frame}{kwic}(x)

\S4method{length}{kwic}(x)

\S4method{sample}{kwic}(x, size)

\S4method{enrich}{kwic}(.Object, meta = NULL, table = FALSE)

\S4method{highlight}{kwic}(.Object, highlight = list(), regex = FALSE,
  perl = TRUE, tooltips = NULL, verbose = TRUE)

\S4method{view}{kwic}(.Object)
}
\arguments{
\item{object}{an object of class \code{kwic}}

\item{x}{a kwic-class object}

\item{size}{integer, the subset size for sampling}

\item{.Object}{a kwic object}

\item{meta}{sAttributes (character vector) with metainformation}

\item{table}{logical, whether to turn cpos data.table into data.frame for output}

\item{highlight}{a list}

\item{regex}{logical, whether to use regular expressions}

\item{perl}{logical, whether to use perl-style regular expressions for highlighting when regex is TRUE}

\item{tooltips}{a list}

\item{verbose}{logical}
}
\description{
S4 class for organizing information for concordance output
}
\details{
The \code{enrich} method is used to generate the actual output for
the kwic method. If param \code{table} is \code{TRUE}, corpus positions will
be turned into a data.frame with the concordance lines. If param \code{meta}
is a character vector with s-attributes, the respective s-attributes will be
added as columns to the table with concordance lines.
}
\section{Slots}{

\describe{
\item{\code{metadata}}{Object of class \code{"character"} keeping the sAttributes of the metadata that are to be displayed}

\item{\code{left}}{words to the left}

\item{\code{right}}{words to the right}

\item{\code{corpus}}{the CWB corpus}

\item{\code{cpos}}{the corpus positions}

\item{\code{table}}{Object of class \code{"data.frame"} a table with the relevant information for kwic output}

\item{\code{encoding}}{Object of class \code{"character"} encoding of the corpus}

\item{\code{labels}}{Object of class \code{"character"}}

\item{\code{categories}}{Object of class \code{"character"}}
}}

\section{Methods}{

  \describe{
   \item{[}{indexing for seeing only some concordances}
   \item{show}{get kwic output}
  }
}

\examples{
\dontrun{
use("polmineR.sampleCorpus")
K <- kwic("PLPRBTTXT", "Integration")
length(K)
K[1]
K[1:5]
}
}
