% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{sim_single_stage}
\alias{sim_single_stage}
\title{Simulate Single-Stage Data}
\usage{
sim_single_stage(
  n = 10000,
  par = c(k = 0.1, d = 0.5, a = 1, b = -2.5, c = 3, p = 0.3),
  action_model = function(Z, L, B, k, d) {
     k * (Z + L - 1) * Z^(-2) + d * (B == 1)

    },
  utility_model = function(Z, L, A, a, b, c) {
     Z + L + A * (c * Z + a * L + b)
 },
  seed = NULL,
  return_model = FALSE,
  ...
)
}
\arguments{
\item{n}{Number of observations.}

\item{par}{Named vector with distributional parameters.
\itemize{
\item{} \code{k}: \eqn{\kappa}
\item{} \code{d}: \eqn{\delta}
\item{} \code{a}: \eqn{\alpha}
\item{} \code{b}: \eqn{\beta}
\item{} \code{c}: \eqn{\gamma}
\item{} \code{p}: \eqn{\pi}
}}

\item{action_model}{Function used to specify the action/treatment probability (logit link).}

\item{utility_model}{Function used to specify the conditional mean utility.}

\item{seed}{Integer.}

\item{return_model}{If TRUE, the \link[lava:lvm]{lava::lvm} model is returned.}

\item{...}{Additional arguments passed to \code{\link[lava:lvm]{lava::lvm()}}.}
}
\value{
data.frame with n rows and columns Z, L, B, A, and U.
}
\description{
Simulate Single-Stage Data
}
\details{
\code{sim_single_stage} samples \code{n} iid observation
\eqn{O = (B, Z, L, A, U)} with the following distribution:
\deqn{
B \sim Bernoulli(\pi)\\
Z, L \sim Uniform([0,1])\\
A\mid Z,L,B \sim Bernoulli(expit\{\kappa Z^{-2}(Z+L-1) + \delta B)\\
U\mid Z,L,A \sim \mathcal{N}(Z+L+A\cdot\{\gamma Z + \alpha L + \beta\}, 1)
}
}
