% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_data_functions.R
\name{get_history_names}
\alias{get_history_names}
\title{Get history variable names}
\usage{
get_history_names(object, stage)
}
\arguments{
\item{object}{Policy data object created by \code{\link[=policy_data]{policy_data()}}.}

\item{stage}{Stage number. If NULL, the state/Markov-type history variable
names are returned.}
}
\value{
Character vector.
}
\description{
\code{get_history_names()} returns the state covariate names of the history data
table for a given stage. The function is useful when specifying
the design matrix for \link{g_model} and \link{q_model} objects.
}
\examples{
library("polle")
### Multiple stages:
source(system.file("sim", "multi_stage.R", package="polle"))
d3 <- sim_multi_stage(5e2, seed = 1)
pd3 <- policy_data(data = d3$stage_data,
                   baseline_data = d3$baseline_data,
                   type = "long",
                   id = "id",
                   stage = "stage",
                   event = "event",
                   action = "A",
                   utility = "U")
pd3
# state/Markov type history variable names (H):
get_history_names(pd3)
# full history variable names (H_k) at stage 2:
get_history_names(pd3, stage = 2)
}
