% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_causal_forest.R
\name{predict.multi_causal_forest}
\alias{predict.multi_causal_forest}
\title{Predict with multi_causal_forest}
\usage{
\method{predict}{multi_causal_forest}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{The trained forest.}

\item{newdata}{Points at which predictions should be made. If NULL, makes out-of-bag
predictions on the training set instead (i.e., provides predictions at
Xi using only trees that did not use the i-th training example). Note
that this matrix should have the number of columns as the training
matrix, and that the columns must appear in the same order.}

\item{...}{Additional arguments passed to
\href{https://grf-labs.github.io/grf/reference/predict.causal_forest.html}{grf::predict.causal_forest}.}
}
\value{
List containing matrix of predictions and other estimates (debiased error, etc.) for each treatment.
}
\description{
Computes estimates of \eqn{\tau_a(x)}
}
\examples{
\donttest{
n <- 250
p <- 10
X <- matrix(rnorm(n * p), n, p)
W <- sample(c("A", "B", "C"), n, replace = TRUE)
Y <- X[, 1] + X[, 2] * (W == "B") + X[, 3] * (W == "C") + runif(n)
mcf <- multi_causal_forest(X = X, Y = Y, W = W)
head(predict(mcf)$predictions)
}
}
