expected_iris_select_df = structure(list(miah = c(
  171.4, 171.4, 171.4, 171.4, 171.4, 171.4,
  171.4, 171.4, 171.4, 171.4, 171.4, 171.4, 171.4, 171.4, 171.4,
  171.4, 171.4, 171.4, 171.4, 171.4, 171.4, 171.4, 171.4, 171.4,
  171.4, 171.4, 171.4, 171.4, 171.4, 171.4, 171.4, 171.4, 171.4,
  171.4, 171.4, 171.4, 171.4, 171.4, 171.4, 171.4, 171.4, 171.4,
  171.4, 171.4, 171.4, 171.4, 171.4, 171.4, 171.4, 171.4, 138.5,
  138.5, 138.5, 138.5, 138.5, 138.5, 138.5, 138.5, 138.5, 138.5,
  138.5, 138.5, 138.5, 138.5, 138.5, 138.5, 138.5, 138.5, 138.5,
  138.5, 138.5, 138.5, 138.5, 138.5, 138.5, 138.5, 138.5, 138.5,
  138.5, 138.5, 138.5, 138.5, 138.5, 138.5, 138.5, 138.5, 138.5,
  138.5, 138.5, 138.5, 138.5, 138.5, 138.5, 138.5, 138.5, 138.5,
  138.5, 138.5, 138.5, 138.5, 148.7, 148.7, 148.7, 148.7, 148.7,
  148.7, 148.7, 148.7, 148.7, 148.7, 148.7, 148.7, 148.7, 148.7,
  148.7, 148.7, 148.7, 148.7, 148.7, 148.7, 148.7, 148.7, 148.7,
  148.7, 148.7, 148.7, 148.7, 148.7, 148.7, 148.7, 148.7, 148.7,
  148.7, 148.7, 148.7, 148.7, 148.7, 148.7, 148.7, 148.7, 148.7,
  148.7, 148.7, 148.7, 148.7, 148.7, 148.7, 148.7, 148.7, 148.7
), miah2 = c(
  250.3, 250.3, 250.3, 250.3, 250.3, 250.3, 250.3,
  250.3, 250.3, 250.3, 250.3, 250.3, 250.3, 250.3, 250.3, 250.3,
  250.3, 250.3, 250.3, 250.3, 250.3, 250.3, 250.3, 250.3, 250.3,
  250.3, 250.3, 250.3, 250.3, 250.3, 250.3, 250.3, 250.3, 250.3,
  250.3, 250.3, 250.3, 250.3, 250.3, 250.3, 250.3, 250.3, 250.3,
  250.3, 250.3, 250.3, 250.3, 250.3, 250.3, 250.3, 296.8, 296.8,
  296.8, 296.8, 296.8, 296.8, 296.8, 296.8, 296.8, 296.8, 296.8,
  296.8, 296.8, 296.8, 296.8, 296.8, 296.8, 296.8, 296.8, 296.8,
  296.8, 296.8, 296.8, 296.8, 296.8, 296.8, 296.8, 296.8, 296.8,
  296.8, 296.8, 296.8, 296.8, 296.8, 296.8, 296.8, 296.8, 296.8,
  296.8, 296.8, 296.8, 296.8, 296.8, 296.8, 296.8, 296.8, 296.8,
  296.8, 296.8, 296.8, 329.4, 329.4, 329.4, 329.4, 329.4, 329.4,
  329.4, 329.4, 329.4, 329.4, 329.4, 329.4, 329.4, 329.4, 329.4,
  329.4, 329.4, 329.4, 329.4, 329.4, 329.4, 329.4, 329.4, 329.4,
  329.4, 329.4, 329.4, 329.4, 329.4, 329.4, 329.4, 329.4, 329.4,
  329.4, 329.4, 329.4, 329.4, 329.4, 329.4, 329.4, 329.4, 329.4,
  329.4, 329.4, 329.4, 329.4, 329.4, 329.4, 329.4, 329.4
), Petal.Length = c(
  1.4,
  1.4, 1.3, 1.5, 1.4, 1.7, 1.4, 1.5, 1.4, 1.5, 1.5, 1.6, 1.4, 1.1,
  1.2, 1.5, 1.3, 1.4, 1.7, 1.5, 1.7, 1.5, 1, 1.7, 1.9, 1.6, 1.6,
  1.5, 1.4, 1.6, 1.6, 1.5, 1.5, 1.4, 1.5, 1.2, 1.3, 1.4, 1.3, 1.5,
  1.3, 1.3, 1.3, 1.6, 1.9, 1.4, 1.6, 1.4, 1.5, 1.4, 4.7, 4.5, 4.9,
  4, 4.6, 4.5, 4.7, 3.3, 4.6, 3.9, 3.5, 4.2, 4, 4.7, 3.6, 4.4,
  4.5, 4.1, 4.5, 3.9, 4.8, 4, 4.9, 4.7, 4.3, 4.4, 4.8, 5, 4.5,
  3.5, 3.8, 3.7, 3.9, 5.1, 4.5, 4.5, 4.7, 4.4, 4.1, 4, 4.4, 4.6,
  4, 3.3, 4.2, 4.2, 4.2, 4.3, 3, 4.1, 6, 5.1, 5.9, 5.6, 5.8, 6.6,
  4.5, 6.3, 5.8, 6.1, 5.1, 5.3, 5.5, 5, 5.1, 5.3, 5.5, 6.7, 6.9,
  5, 5.7, 4.9, 6.7, 4.9, 5.7, 6, 4.8, 4.9, 5.6, 5.8, 6.1, 6.4,
  5.6, 5.1, 5.6, 6.1, 5.6, 5.5, 4.8, 5.4, 5.6, 5.1, 5.1, 5.9, 5.7,
  5.2, 5, 5.2, 5.4, 5.1
)), class = "data.frame", row.names = c(
  NA,
  -150L
))


patrick::with_parameters_test_that("DataFrame, mixed input, create and print",
  {
    input_vectors_and_series = list(
      newname = pl$Series(c(1, 2, 3, 4, 5), name = "b"), # overwrite name b with newname
      pl$Series((1:5) * 5, "a"),
      pl$Series(letters[1:5], "b"),
      c(5, 4, 3, 2, 1), # unnamed vector
      named_vector = c(15, 14, 13, 12, 11), # named provide
      c(5, 4, 3, 2, 0)
    )

    # clone into DataFrame and change one name
    df = pl$DataFrame(input_vectors_and_series)
    .env_var = .value
    names(.env_var) = .name
    withr::with_envvar(.env_var, expect_snapshot(df))
  },
  .cases = make_print_cases()
)

test_that("DataFrame, input free vectors, input empty", {
  # passing vector directly is equal to passing one
  l = as.list(iris)
  df1 = pl$DataFrame(l)
  df2 = do.call(pl$DataFrame, l)
  expect_identical(
    df1$to_list(), df2$to_list()
  )
  df_e = pl$DataFrame()
  expect_s3_class(df_e, "DataFrame")
  expect_identical(df_e$shape, c(0, 0))
  expect_identical(pl$DataFrame()$to_list(), .pr$DataFrame$default()$to_list())
})

test_that("get set properties", {
  df = pl$DataFrame(list(a = 1:5, b = rep(TRUE, 5)))

  expect_equal(
    df$columns,
    c("a", "b")
  )

  df2 = df
  df2$columns = c("alice", "bob")

  expect_equal(
    df2$columns,
    c("alice", "bob")
  )

  # immutable by default see strictly_immutable option
  expect_different(df2$columns, df$columns)

  # cannot set property without setter method
  expect_error(df$height <- 10)

  # other getable properties
  expect_equal(df$height, 5L)
  expect_equal(df$width, 2L)
  expect_equal(df$shape, c(5L, 2L))

  # dtypes from object are as expected
  expect_true(
    all(mapply(
      df$dtypes,
      pl$dtypes[c("Int32", "Boolean")],
      FUN = "=="
    ))
  )
  expect_null(names(df$dtypes))

  expect_true(
    all(mapply(
      df$schema,
      pl$dtypes[c("Int32", "Boolean")],
      FUN = "=="
    ))
  )

  expect_equal(
    df$columns,
    names(df$schema)
  )
})

test_that("DataFrame, select sum over", {
  df = pl$DataFrame(iris)$select(
    pl$col("Sepal.Width")$sum()$over("Species")$alias("miah"),
    pl$col("Sepal.Length")$sum()$over("Species")$alias("miah2"),
    "Petal.Length"
  )

  expect_equal(
    df$to_data_frame(),
    expected_iris_select_df
  )

  expect_equal(
    as.data.frame(df),
    expected_iris_select_df
  )
})

test_that("Select with p$col", {
  x = pl$DataFrame(mtcars)$select(pl$col("mpg", "hp"))
  y = pl$DataFrame(mtcars)$select(pl$col(c("mpg", "hp")))
  z = pl$DataFrame(mtcars)$select(pl$col("mpg"), pl$col("hp"))
  expect_equal(x$columns, c("mpg", "hp"))
  expect_equal(y$columns, c("mpg", "hp"))
  expect_equal(z$columns, c("mpg", "hp"))
})

test_that("select with list of exprs", {
  l_expr = list(pl$col("mpg"), pl$col("hp"))
  l_expr2 = list(pl$col("mpg", "hp"))
  l_expr3 = list(pl$col("mpg"))
  l_expr4 = list(c("mpg", "hp"))
  l_expr5 = list("mpg", "hp")

  x1 = pl$DataFrame(mtcars)$select(l_expr)
  x2 = pl$DataFrame(mtcars)$select(l_expr2)
  # x3 = pl$DataFrame(mtcars)$select(l_expr3, pl$col("hp")) #not allowed
  # x4 = pl$DataFrame(mtcars)$select(pl$col("hp"), l_expr3) #not allowed
  x5 = pl$DataFrame(mtcars)$select(l_expr4)
  x6 = pl$DataFrame(mtcars)$select(l_expr5)

  expect_equal(x1$columns, c("mpg", "hp"))
  expect_equal(x2$columns, c("mpg", "hp"))
  # expect_equal(x3$columns, c("mpg", "hp"))
  # expect_equal(x4$columns, c("mpg", "hp"))
  expect_equal(x5$columns, c("mpg", "hp"))
  expect_equal(x6$columns, c("mpg", "hp"))
})

test_that("map unity", {
  x = pl$
    DataFrame(iris)$
    select(
    pl$col("Sepal.Length")$
      map(\(s) s)
  )$
    to_data_frame()[, 1, drop = FALSE]

  # float is preserved
  expect_identical(
    x,
    iris[, 1, drop = FALSE]
  )

  # int is preseved
  int_iris = iris
  int_iris[, 1:4] = lapply(iris[, 1:4], as.integer)
  x = pl$
    DataFrame(int_iris)$
    select(
    pl$col("Sepal.Length")$
      map(\(s) s)
  )$
    to_data_frame()[, 1, drop = FALSE]

  expect_identical(
    x,
    int_iris[, 1, drop = FALSE]
  )

  # drop the dataframe structure
  x = pl$
    DataFrame(iris)$
    select(
    pl$col("Species")$
      map(\(s) s)
  )$
    to_data_frame()[, 1]

  expect_different(x, iris[, 1, drop = FALSE])


  x = pl$
    DataFrame(iris)$
    select(
    pl$col("Species")$
      map(\(s) s)
  )$
    to_data_frame()
  expect_identical(x, iris[, 5, drop = FALSE])
})


test_that("map type", {
  int_iris = iris
  int_iris[] = lapply(iris, as.integer)

  # auto new type allowed if return is R vector
  x = pl$DataFrame(iris)$
    select(
    pl$col("Sepal.Length")$
      map(\(s) {
      as.integer(s$to_r()) # ok to return R vector also, will be
      # converted back to series named ""
    })$
      map(\(s) s * 25L)$
      map(\(s) s / 4)
  )$
    to_data_frame()[, 1, drop = FALSE]

  expect_identical(x, int_iris[, 1, drop = FALSE] * 25L / 4L)
})

test_that("cloning", {
  pf = pl$DataFrame(iris)

  # shallow copy, same external pointer
  pf2 = pl$DataFrame(pf)
  expect_identical(pf, pf2)
  expect_identical(pl$mem_address(pf), pl$mem_address(pf2))

  # deep copy clone rust side object, hence not same mem address
  # For some reason, expect_identical(pf, pf3) fails
  pf3 = pf$clone()
  expect_identical(pf$to_data_frame(), pf3$to_data_frame())
  expect_different(pl$mem_address(pf), pl$mem_address(pf3))
})


# TODO figure out why this test fails. Expected and Actual do appear very much equal
# test_that("get column(s)", {
# df = pl$DataFrame(iris)
# expected_list_of_series = {
#   expected = lapply(
#     1:5,
#     function(i) pl$Series(iris[[i]],names(iris)[i])
#   )
#   names(expected) = names(iris)
#   expected
# }
# actual_list_of_series = df$get_columns()
# for (i in 1:5) {
#   is_equal = expected_list_of_series[[i]]$series_equal(actual_list_of_series[[i]])
#   if (!is_equal) {
#     fail("series are not equal according to polars internal check")
#   }
# }


# list_of_vectors = lapply(actual_list_of_series, function(x) x$to_vector())
# expect_identical(
#   list_of_vectors,
#   as.list(iris)
# )
# })


test_that("get column", {
  expect_true(
    pl$DataFrame(iris)$get_column("Sepal.Length")$series_equal(
      pl$Series(iris$Sepal.Length, "Sepal.Length")
    )
  )

  expect_error(
    pl$DataFrame(iris)$get_column("wrong_name")
  )
})



# TODO implement series cast and test Series_equal


test_that("with_columns lazy/eager", {
  l = list(
    a = 1:4,
    b = c(.5, 4, 10, 13),
    c = c(TRUE, TRUE, FALSE, TRUE)
  )
  df = pl$DataFrame(l)
  ldf = df$lazy()

  df_actual = df$with_columns(
    (pl$col("a") * 2)$alias("a*2"),
    (pl$col("b") / 2)$alias("b/2"),
    (!pl$col("c"))$alias("not c")
  )
  ldf_actual = ldf$with_columns(
    (pl$col("a") * 2)$alias("a*2"),
    (pl$col("b") / 2)$alias("b/2"),
    (!pl$col("c"))$alias("not c")
  )

  rdf = list2DF(l)
  rdf$`a*2` = rdf$a * 2
  rdf$`b/2` = rdf$b / 2
  rdf$`not c` = !rdf$c

  expect_identical(
    df_actual$to_data_frame(check.names = FALSE),
    rdf
  )

  expect_identical(
    ldf_actual$collect()$to_data_frame(check.names = FALSE),
    rdf
  )

  # check
  pl$set_polars_options(named_exprs = TRUE)
  ldf_actual_kwarg_named = ldf$with_columns(
    "a*2" = (pl$col("a") * 2),
    "b/2" = (pl$col("b") / 2),
    "not c" = (!pl$col("c"))
  )
  pl$reset_polars_options()

  expect_identical(
    ldf_actual_kwarg_named$collect()$to_data_frame(check.names = FALSE),
    rdf
  )
})


test_that("limit lazy/eager", {
  l = list(
    a = 1:4,
    b = c(.5, 4, 10, 13),
    c = c(TRUE, TRUE, FALSE, TRUE)
  )
  df = pl$DataFrame(l)
  ldf = df$lazy()
  rdf = df$to_data_frame()

  expect_identical(
    df$limit(2)$to_data_frame(),
    rdf[1:2, ]
  )

  expect_identical(
    ldf$limit(2)$collect()$to_data_frame(),
    rdf[1:2, ]
  )

  # lazy bounds
  expect_identical(df$limit(0)$to_data_frame(), rdf[integer(), ])
  expect_error(ldf$limit(-1))
  expect_error(ldf$limit(2^32))
  expect_identical(ldf$limit(2^32 - 1)$collect()$to_data_frame(), rdf)

  # eager bounds
  expect_identical(ldf$limit(0)$collect()$to_data_frame(), rdf[integer(), ])
  expect_error(df$limit(-1))
  expect_error(df$limit(2^32))
  expect_identical(df$limit(2^32 - 1)$to_data_frame(), rdf)
})



test_that("to_Struct, unnest, to_frame, to_data_frame", {
  # round-trip conversion from DataFrame with two columns
  df = pl$DataFrame(
    a = 1:5,
    b = c("one", "two", "three", "four", "five"),
    c = TRUE,
    d = 42.0,
    e = NaN,
    f = NA_real_
  )
  s = df$to_struct()
  df_s = s$to_frame() # place series in a new DataFrame

  expect_identical(df$to_list(), df_s$unnest()$to_list())
  expect_identical(df$to_list(), df_s$to_list(unnest_structs = TRUE)[[1L]])

  # tedious way to unnest a data.frame of one column struct
  df_e = as.data.frame(do.call(rbind, df_s$to_data_frame()[[1L]])) |>
    lapply(unlist) |>
    as.data.frame()
  expect_identical(df$to_data_frame(), df_e)
})

make_cases = function() {
  tibble::tribble(
    ~.test_name, ~pola, ~base,
    "max", "max", max,
    "mean", "mean", mean,
    "median", "median", median,
    "max", "max", max,
    "min", "min", min,
    "std", "std", sd,
    "sum", "sum", sum,
    "var", "var", var,
    "first", "first", function(x) head(x, 1),
    "last", "last", function(x) tail(x, 1)
  )
}

patrick::with_parameters_test_that(
  "simple translations: eager",
  {
    a = pl$DataFrame(mtcars)[[pola]]()$to_data_frame()
    b = data.frame(lapply(mtcars, base))
    testthat::expect_equal(a, b, ignore_attr = TRUE)
  },
  .cases = make_cases()
)

test_that("simple translations", {
  a = pl$DataFrame(mtcars)$var(10)$to_data_frame()
  b = data.frame(lapply(mtcars, var))
  expect_true(all(a != b))

  a = pl$DataFrame(mtcars)$std(10)$to_data_frame()
  b = data.frame(lapply(mtcars, sd))
  expect_true(all(a != b))

  a = pl$DataFrame(mtcars)$reverse()$to_data_frame()
  b = mtcars[32:1, ]
  expect_equal(a, b, ignore_attr = TRUE)

  a = pl$DataFrame(mtcars)$slice(2, 4)$to_data_frame()
  b = mtcars[3:6, ]
  expect_equal(a, b, ignore_attr = TRUE)

  a = pl$DataFrame(mtcars)$slice(30)$to_data_frame()
  b = tail(mtcars, 2)
  expect_equal(a, b, ignore_attr = TRUE)

  a = pl$DataFrame(mtcars)$estimated_size()
  expect_equal(a, 2816, tolerance = .1)

  # trigger u8 conversion errors
  expect_grepl_error(pl$DataFrame(mtcars)$std(256), c("ddof", "exceed the upper bound for u8 of 255"))
  expect_grepl_error(
    pl$DataFrame(mtcars)$var(-1),
    c("ddof", "cannot be less than zero")
  )
})


test_that("null_count 64bit", {
  skip_if_not_installed("bit64")
  suppressPackageStartupMessages(library("bit64", quietly = TRUE))
  tmp = mtcars
  tmp[1:2, 1:2] = NA
  tmp[5, 3] = NA
  a = pl$DataFrame(tmp)$null_count()$to_data_frame()
  a = sapply(a, as.integer)
  b = sapply(tmp, function(x) sum(is.na(x)))
  expect_equal(a, b)

  a = pl$DataFrame(tmp)$groupby("vs")$null_count()$to_data_frame()
  expect_equal(dim(a), c(2, 11))
})

test_that("tail", {
  a = as.data.frame(pl$DataFrame(mtcars)$tail(6))
  b = tail(mtcars)
  expect_equal(a, b, ignore_attr = TRUE)
})

test_that("drop_in_place", {
  dat = pl$DataFrame(iris)
  expect_true("Species" %in% dat$columns)
  x = dat$drop_in_place("Species")
  expect_false("Species" %in% dat$columns)
  expect_s3_class(x, "Series")
})


test_that("shift   _and_fill", {
  a = pl$DataFrame(mtcars)$shift(2)$limit(3)$as_data_frame()
  for (i in seq_along(a)) {
    expect_equal(is.na(a[[i]]), c(TRUE, TRUE, FALSE))
  }
  a = pl$DataFrame(mtcars)$shift_and_fill(0., 2.)$limit(3)$as_data_frame()
  for (i in seq_along(a)) {
    expect_equal(a[[i]], c(0, 0, mtcars[[i]][1]))
  }
})


test_that("frame_equal", {
  dat1 = pl$DataFrame(iris)
  dat2 = pl$DataFrame(mtcars)
  expect_true(dat1$frame_equal(dat1))
  expect_false(dat1$frame_equal(dat2))
})

test_that("fill_nan", {
  a = pl$DataFrame(a = c(NaN, 1:2), b = c(1, NaN, NaN))
  a = a$fill_nan(99)$as_data_frame()
  expect_equal(sum(a[[1]] == 99), 1)
  expect_equal(sum(a[[2]] == 99), 2)
})

test_that("quantile", {
  a = pl$DataFrame(mtcars)$quantile(1, "midpoint")$as_data_frame()
  b = pl$DataFrame(mtcars)$max()$as_data_frame()
  expect_equal(a, b, ignore_attr = TRUE)

  a = pl$DataFrame(mtcars)$quantile(0, "midpoint")$as_data_frame()
  b = pl$DataFrame(mtcars)$min()$as_data_frame()
  expect_equal(a, b, ignore_attr = TRUE)

  a = pl$DataFrame(mtcars)$quantile(0.5, "midpoint")$as_data_frame()
  b = pl$DataFrame(mtcars)$median()$as_data_frame()
  expect_equal(a, b, ignore_attr = TRUE)
})


test_that("drop", {
  a = pl$DataFrame(mtcars)$drop(c("mpg", "hp"))$columns
  expect_false("hp" %in% a)
  expect_false("mpg" %in% a)
  a = pl$DataFrame(mtcars)$drop("mpg")$columns
  expect_true("hp" %in% a)
  expect_false("mpg" %in% a)
})


test_that("drop_nulls", {
  tmp = mtcars
  tmp[1:3, "mpg"] = NA
  expect_equal(pl$DataFrame(mtcars)$drop_nulls()$height, 32, ignore_attr = TRUE)
  expect_equal(pl$DataFrame(tmp)$drop_nulls()$height, 29, ignore_attr = TRUE)
  expect_equal(pl$DataFrame(mtcars)$drop_nulls("mpg")$height, 32, ignore_attr = TRUE)
  expect_equal(pl$DataFrame(tmp)$drop_nulls("mpg")$height, 29, ignore_attr = TRUE)
  expect_equal(pl$DataFrame(tmp)$drop_nulls("hp")$height, 32, ignore_attr = TRUE)
  expect_equal(pl$DataFrame(tmp)$drop_nulls(c("mpg", "hp"))$height, 29, ignore_attr = TRUE)
  expect_grepl_error(
    pl$DataFrame(mtcars)$drop_nulls("bad")$height,
    "ColumnNotFound"
  )
})


test_that("fill_nulls", {
  df = pl$DataFrame(
    a = c(1.5, 2, NA, 4),
    b = c(1.5, NA, NA, 4)
  )$fill_null(99)$as_data_frame()
  expect_equal(sum(df$a == 99), 1)
  expect_equal(sum(df$b == 99), 2)
})


test_that("unique", {
  df = pl$DataFrame(
    x = as.numeric(c(1, 1:5)),
    y = as.numeric(c(1, 1:5)),
    z = as.numeric(c(1, 1, 1:4))
  )
  v = df$unique()$height
  w = df$unique("z", "first")$height
  x = df$unique(c("x", "y", "z"), "first")$height
  y = df$unique(c("x"), "first")$height
  z = df$unique(c("y", "z"), "first")$height
  expect_equal(v, 5)
  expect_equal(w, 4)
  expect_equal(x, 5)
  expect_equal(y, 5)
  expect_equal(z, 5)

  x = df$unique("z", "first")$to_data_frame()
  y = df$unique("z", "last")$to_data_frame()
  expect_false(all(x == y))
})

test_that("unique, maintain_order", {
  df = pl$DataFrame(
    x = rep(1:100, each = 2)
  )
  expect_equal(
    df$unique(maintain_order = TRUE)$to_data_frame()$x,
    1:100
  )
})

test_that("as_data_frame (backward compatibility)", {
  w = as.data.frame(pl$DataFrame(mtcars)$to_data_frame())
  x = as.data.frame(pl$DataFrame(mtcars)$as_data_frame())
  y = mtcars
  expect_equal(w, x, ignore_attr = TRUE)
  expect_equal(w, y, ignore_attr = TRUE)
})


test_that("sort", {
  df = pl$DataFrame(mtcars)

  w = df$sort("mpg")$to_data_frame()
  x = df$sort(pl$col("mpg"))$to_data_frame()
  y = mtcars[order(mtcars$mpg), ]
  expect_equal(x, y, ignore_attr = TRUE)

  w = df$sort(pl$col("cyl"), pl$col("mpg"))$to_data_frame()
  x = df$sort("cyl", "mpg")$to_data_frame()
  y = df$sort(c("cyl", "mpg"))$to_data_frame()
  z = mtcars[order(mtcars$cyl, mtcars$mpg), ]
  expect_equal(w, x, ignore_attr = TRUE)
  expect_equal(w, y, ignore_attr = TRUE)
  expect_equal(w, z, ignore_attr = TRUE)

  # expr: one increasing and one decreasing
  x = df$sort(-pl$col("cyl"), pl$col("hp"))$to_data_frame()
  y = mtcars[order(-mtcars$cyl, mtcars$hp), ]
  expect_equal(x, y, ignore_attr = TRUE)

  # descending arg
  w = df$sort("cyl", "mpg", descending = TRUE)$to_data_frame()
  x = df$sort(c("cyl", "mpg"), descending = TRUE)$to_data_frame()
  y = mtcars[order(-mtcars$cyl, -mtcars$mpg), ]
  expect_equal(w, x, ignore_attr = TRUE)
  expect_equal(w, y, ignore_attr = TRUE)

  # descending arg: vector of boolean
  w = df$sort("cyl", "mpg", descending = c(TRUE, FALSE))$to_data_frame()
  x = df$sort(c("cyl", "mpg"), descending = c(TRUE, FALSE))$to_data_frame()
  y = mtcars[order(-mtcars$cyl, mtcars$mpg), ]
  expect_equal(w, x, ignore_attr = TRUE)
  expect_equal(w, y, ignore_attr = TRUE)

  # nulls_last
  df = mtcars
  df$mpg[1] = NA
  df = pl$DataFrame(df)
  a = df$sort("mpg", nulls_last = TRUE)$to_data_frame()
  b = df$sort("mpg", nulls_last = FALSE)$to_data_frame()
  expect_true(is.na(a$mpg[32]))
  expect_true(is.na(b$mpg[1]))
})

test_that("dtype_strings", {
  df_1 = pl$DataFrame(data.frame(a = 1L, b = 1.0, c = "1", d = I(list(1))))
  expect_equal(df_1$dtype_strings(), c("i32", "f64", "str", "list[f64]"))
})


test_that("join_asof_simple", {
  l_gdp = list(
    date = as.Date(c("2016-1-1", "2017-1-1", "2018-1-1", "2019-1-1")),
    gdp = c(4164, 4411, 4566, 4696),
    group_right = c("a", "a", "b", "b")
  )
  l_pop = list(
    date = as.Date(c("2016-5-12", "2017-5-12", "2018-5-12", "2019-5-12")),
    population = c(82.19, 82.66, 83.12, 83.52),
    group = c("b", "b", "a", "a")
  )

  gdp = pl$DataFrame(l_gdp)$sort("date")
  pop = pl$DataFrame(l_pop)$sort("date")

  # strategy param
  expect_identical(
    pop$join_asof(gdp, left_on = "date", right_on = "date", strategy = "backward")$to_list(),
    c(l_pop, l_gdp[c("gdp", "group_right")])
  )
  expect_identical(
    pop$join_asof(gdp, left_on = "date", right_on = "date", strategy = "forward")$to_list(),
    c(l_pop, gdp$shift(-1)$to_list()[c("gdp", "group_right")])
  )
  expect_grepl_error(
    pop$join_asof(gdp, left_on = "date", right_on = "date", strategy = "fruitcake"),
    c("join_asof", "strategy choice", "fruitcake")
  )

  # shared left_right on
  expect_identical(
    pop$join_asof(gdp, on = "date", strategy = "backward")$to_list(),
    c(l_pop, l_gdp[c("gdp", "group_right")])
  )

  # test by
  expect_identical(
    pop$join_asof(
      gdp,
      on = "date", by_left = "group",
      by_right = "group_right", strategy = "backward"
    )$to_list(),
    c(l_pop, list(gdp = l_gdp$gdp[c(NA, NA, 2, 2)]))
  )
  expect_identical(
    pop$join_asof(
      gdp,
      on = "date", by_left = "group",
      by_right = "group_right", strategy = "forward"
    )$to_list(),
    c(l_pop, list(gdp = l_gdp$gdp[c(3, 3, NA, NA)]))
  )


  # str_tolerance within 19w
  expect_identical(
    pop$join_asof(gdp, on = "date", strategy = "backward", tolerance = "19w")$to_list(),
    pop$join_asof(gdp, on = "date", strategy = "backward")$to_list()
  )


  # exceeding 18w
  expect_identical(
    pop$join_asof(gdp, on = "date", strategy = "backward", tolerance = "18w")$to_list(),
    pop$join_asof(gdp, on = "date", strategy = "backward")$with_columns(
      pl$lit(NA_real_)$alias("gdp"),
      pl$lit(NA_character_)$alias("group_right")
    )$to_list()
  )

  # num_tolerance within 19w = 19*7 days
  expect_identical(
    pop$join_asof(gdp, on = "date", strategy = "backward", tolerance = 19 * 7)$to_list(),
    pop$join_asof(gdp, on = "date", strategy = "backward")$to_list()
  )

  expect_identical(
    pop$join_asof(gdp, on = "date", strategy = "backward", tolerance = 18 * 7)$to_list(),
    pop$join_asof(gdp, on = "date", strategy = "backward")$with_columns(
      pl$lit(NA_real_)$alias("gdp"),
      pl$lit(NA_character_)$alias("group_right")
    )$to_list()
  )
})


test_that("melt example", {
  df = pl$DataFrame(
    a = c("x", "y", "z"),
    b = c(1, 3, 5),
    c = c(2, 4, 6)
  )

  expect_identical(
    df$melt(id_vars = "a", value_vars = c("b", "c"))$to_list(),
    list(
      a = c("x", "y", "z", "x", "y", "z"),
      variable = c("b", "b", "b", "c", "c", "c"),
      value = c(1, 3, 5, 2, 4, 6)
    )
  )
})

test_that("melt vs data.table::melt", {
  skip_if_not_installed("data.table")
  pdf = pl$DataFrame(
    a = c("x", "y", "z"),
    b = c(1, 3, 5),
    c = c(2, 4, 6)
  )

  rdf = pdf$to_data_frame()
  dtt = data.table::data.table(rdf)

  melt_mod = \(...) {
    data.table::melt(variable.factor = FALSE, value.factor = FALSE, ...)
  }

  expect_identical(
    pdf$melt(id_vars = "a", value_vars = c("b", "c"))$to_list(),
    as.list(melt_mod(dtt, id.vars = "a", value_vars = c("b", "c")))
  )
  expect_identical(
    pdf$melt(id_vars = c("c", "b"), value_vars = c("a"))$to_list(),
    as.list(melt_mod(dtt, id.vars = c("c", "b"), value_vars = c("a")))
  )
  expect_identical(
    pdf$melt(id_vars = c("a", "b"), value_vars = c("c"))$to_list(),
    as.list(melt_mod(dtt, id.vars = c("a", "b"), value_vars = c("b", "c")))
  )


  expect_identical(
    pdf$melt(
      id_vars = c("a", "b"), value_vars = c("c"), value_name = "alice", variable_name = "bob"
    )$to_list(),
    as.list(melt_mod(
      dtt,
      id.vars = c("a", "b"), value_vars = c("b", "c"), value.name = "alice", variable.name = "bob"
    ))
  )

  # check the check, this should not be equal
  expect_error(expect_equal(
    pdf$melt(id_vars = c("c", "b"), value_vars = c("a"))$to_list(),
    as.list(melt_mod(dtt, id.vars = c("a", "b"), value_vars = c("c")))
  ))
})





test_that("pivot examples", {
  df = pl$DataFrame(
    foo = c("one", "one", "one", "two", "two", "two"),
    bar = c("A", "B", "C", "A", "B", "C"),
    baz = c(1, 2, 3, 4, 5, 6)
  )

  expect_identical(
    df$pivot(
      values = "baz", index = "foo", columns = "bar", aggregate_function = "first"
    )$to_list(),
    list(foo = c("one", "two"), A = c(1, 4), B = c(2, 5), C = c(3, 6))
  )


  # Run an expression as aggregation function
  df = pl$DataFrame(
    col1 = c("a", "a", "a", "b", "b", "b"),
    col2 = c("x", "x", "x", "x", "y", "y"),
    col3 = c(6, 7, 3, 2, 5, 7)
  )

  expect_equal(
    df$pivot(
      index = "col1",
      columns = "col2",
      values = "col3",
      aggregate_function = pl$element()$tanh()$mean()
    )$to_list(),
    list(
      col1 = c("a", "b"),
      x = c(0.998346934093824, 0.964027580075817),
      y = c(NA, 0.99995377060327)
    )
  )
})


test_that("pivot args works", {
  df = pl$DataFrame(
    foo = c("one", "one", "one", "two", "two", "two"),
    bar = c("A", "B", "C", "A", "B", "C"),
    baz = c(1, 2, 3, 4, 5, 6),
    jaz = 6:1
  )
  expect_identical(
    df$pivot("foo", "bar", "baz")$to_list(),
    list(bar = c("A", "B", "C"), `1.0` = c("one", NA, NA), `2.0` = c(
      NA,
      "one", NA
    ), `3.0` = c(NA, NA, "one"), `4.0` = c("two", NA, NA), `5.0` = c(NA, "two", NA), `6.0` = c(NA, NA, "two"))
  )

  df = pl$DataFrame(
    ann = c("one", "one", "one", "two", "two", "two"),
    bob = c("A", "B", "A", "B", "A", "B"),
    cat = c(1, 2, 3, 4, 5, 6)
  )

  # aggr functions
  expect_identical(
    df$pivot("cat", "ann", "bob", "mean")$to_list(),
    list(ann = c("one", "two"), A = c(2, 5), B = c(2, 5))
  )
  expect_identical(
    df$pivot("cat", "ann", "bob", pl$element()$mean())$to_list(),
    df$pivot("cat", "ann", "bob", "mean")$to_list()
  )
  expect_grepl_error(df$pivot("cat", "ann", "bob", 42), c("pivot", "param", "aggregate_function", "42"))
  expect_grepl_error(df$pivot("cat", "ann", "bob", "dummy"), c("pivot", "dummy is not a method"))

  # maintain_order sort_columns
  expect_grepl_error(df$pivot("cat", "ann", "bob", "mean", 42), c("pivot", "maintain_order", "bool"))
  expect_grepl_error(df$pivot("cat", "ann", "bob", "mean", TRUE, 42), c("pivot", "sort_columns", "bool"))

  # separator
  expect_identical(
    names(df$pivot(c("ann", "bob"), "ann", "cat", "mean", sep = ".")),
    c(
      "ann", "ann.cat.1.0", "ann.cat.2.0", "ann.cat.3.0", "ann.cat.4.0",
      "ann.cat.5.0", "ann.cat.6.0", "bob.cat.1.0", "bob.cat.2.0", "bob.cat.3.0",
      "bob.cat.4.0", "bob.cat.5.0", "bob.cat.6.0"
    )
  )
})

test_that("rename", {
  df = pl$DataFrame(mtcars)

  # renaming succeeded
  a = df$rename(miles_per_gallon = "mpg", horsepower = "hp")$columns
  expect_false("hp" %in% a)
  expect_false("mpg" %in% a)
  expect_true("miles_per_gallon" %in% a)
  expect_true("horsepower" %in% a)

  # no args are allowed, but does nothing
  expect_identical(
    df$rename()$to_list(),
    df$to_list()
  )

  # wrapped args in list is equivalent
  b = df$rename(list(miles_per_gallon = "mpg", horsepower = "hp"))$columns
  expect_identical(a, b)
})


test_that("describe", {
  expect_snapshot(pl$DataFrame(mtcars)$describe())

  df = pl$DataFrame(mtcars)$describe()
  expect_error(pl$DataFrame(mtcars)$describe("not a percentile"))
  err_ctx = unwrap_err(result(pl$DataFrame(mtcars)$describe("not a percentile")))$contexts()
  expect_identical(names(err_ctx), c("BadArgument", "TypeMismatch", "BadValue"))
  expect_identical(unlist(err_ctx[1:2], use.names = FALSE), c("percentiles", "numeric"))

  # perc = NULL  is the same as numeric()
  expect_identical(
    pl$DataFrame(mtcars)$describe(perc = numeric())$to_list(),
    pl$DataFrame(mtcars)$describe(perc = NULL)$to_list()
  )
})

test_that("glimpse", {
  expect_snapshot(pl$DataFrame(mtcars)$with_columns(pl$lit(42)$cast(pl$Int8))$glimpse())
  expect_rpolarserr(
    pl$DataFrame(iris)$glimpse(return_as_string = 42),
    c("BadArgument", "TypeMismatch", "BadValue")
  )
  expect_true(is_string(pl$DataFrame(iris)$glimpse(return_as_string = TRUE)))
})
