% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__string.R
\name{ExprStr_contains}
\alias{ExprStr_contains}
\alias{expr_str_contains}
\title{contains}
\arguments{
\item{pattern}{String or Expr of a string, a valid regex pattern.}

\item{literal}{bool, treat pattern as a literal string. NULL is aliased with FALSE.}

\item{strict}{bool, raise an error if the underlying pattern is not a valid
regex expression, otherwise mask out with a null value.}
}
\value{
Expr returning a Boolean
}
\description{
R Check if string contains a substring that matches a regex.
}
\details{
starts_with : Check if string values start with a substring.
ends_with : Check if string values end with a substring.
}
\examples{
df = pl$DataFrame(a = c("Crab", "cat and dog", "rab$bit", NA))
df$select(
  pl$col("a"),
  pl$col("a")$str$contains("cat|bit")$alias("regex"),
  pl$col("a")$str$contains("rab$", literal = TRUE)$alias("literal")
)
}
\keyword{ExprStr}
