% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_reg.R
\name{poisson_reg}
\alias{poisson_reg}
\alias{update.poisson_reg}
\title{Poisson regression models}
\usage{
poisson_reg(
  mode = "regression",
  penalty = NULL,
  mixture = NULL,
  engine = "glm"
)

\method{update}{poisson_reg}(
  object,
  parameters = NULL,
  penalty = NULL,
  mixture = NULL,
  fresh = FALSE,
  ...
)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "regression".}

\item{penalty}{A non-negative number representing the total
amount of regularization (\code{glmnet} only).}

\item{mixture}{A number between zero and one (inclusive) that is the
proportion of L1 regularization (i.e. lasso) in the model. When
\code{mixture = 1}, it is a pure lasso model while \code{mixture = 0} indicates that
ridge regression is being used. (\code{glmnet} and \code{spark} only).}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}

\item{object}{A boosted tree model specification.}

\item{parameters}{A 1-row tibble or named list with \emph{main}
parameters to update. If the individual arguments are used,
these will supersede the values in \code{parameters}. Also, using
engine arguments in this object will result in an error.}

\item{fresh}{A logical for whether the arguments should be
modified in-place of or replaced wholesale.}

\item{...}{Not used for \code{update()}.}
}
\value{
An updated model specification.
}
\description{
\code{poisson_reg()} defines a generalized linear model for count data that follow
a Poisson distribution.
There are different ways to fit this model. See the engine-specific pages
for more details:

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("poisson_reg", "poissonreg")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit.model_spec()}} function is used
with the data.
}
\examples{
poisson_reg()

# Model from Agresti (2007) Table 7.6
log_lin_mod <-
  poisson_reg() \%>\%
  set_engine("glm") \%>\%
  fit(count ~ (.)^2, data = seniors)

summary(log_lin_mod$fit)

# ------------------------------------------------------------------------------

library(pscl)

data("bioChemists", package = "pscl")

poisson_reg() \%>\%
  set_engine("hurdle") \%>\%
# Extended formula:
  fit(art ~ . | phd, data = bioChemists)

model <- poisson_reg(penalty = 10, mixture = 0.1)
model
update(model, penalty = 1)
update(model, penalty = 1, fresh = TRUE)
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Models with R}}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("poisson_reg", "poissonreg")}
}
