% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_po_from_pot.R
\name{generate_po_from_pot}
\alias{generate_po_from_pot}
\alias{generate_po_from_pot.po}
\title{Generate a PO object from a POT object}
\usage{
generate_po_from_pot(x, lang, ...)

\method{generate_po_from_pot}{po}(x, lang, ...)
}
\arguments{
\item{x}{An object of class \code{po}, as read by \code{\link{read_po}} from
a POT file.}

\item{lang}{A language code, possibly with a country code attached. See
\code{\link{language_codes}} for possible values.}

\item{...}{Currently unused.}
}
\value{
An object of class \code{po}, ready to be written to a PO file by
\code{\link{write_po}}.
}
\description{
Generates a PO object from a POT object.
}
\details{
The \code{file_type} element is changed from "pot" to "po", and
"Language" and "Plural-Forms" values are added to the metadata element.
}
\note{
If the plural form is unknown for the specified language, the plural
form is set to \code{NA}.  See \code{\link{plural_forms}} for supported
languages.
}
\examples{
pot_file <- system.file("extdata/R-summerof69.pot", package = "poio")
pot <- read_po(pot_file)
# It's a good idea to fix the metadata before you generate the PO files
pot_fixed <- fix_metadata(pot, system.file(package = "poio"))

# Call generate_po_from_pot for each language that you want to translate to
two_pos <- lapply(
  c(German = "de", Qatari_Arabic = "ar_QA"),
  generate_po_from_pot,
  x = pot_fixed
)

# Notice the Language and Plural-forms elements in the metadata
two_pos$German$metadata
# Also notice that the countable msgstr elements for Arabic now
# have length 6, since Arabic has 6 plural forms
two_pos$Qatari_Arabic$countable$msgstr
}

