% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_write.R
\name{yaml_agent_string}
\alias{yaml_agent_string}
\title{Display \strong{pointblank} YAML using an agent or a YAML file}
\usage{
yaml_agent_string(agent = NULL, filename = NULL, path = NULL, expanded = FALSE)
}
\arguments{
\item{agent}{An \emph{agent} object of class \code{ptblank_agent}. If an object is
provided here, then \code{filename} must not be provided.}

\item{filename}{The name of the YAML file that contains fields related to an
\emph{agent}. If a file name is provided here, then \emph{agent} object must not be
provided in \code{agent}.}

\item{path}{An optional path to the YAML file (combined with \code{filename}).}

\item{expanded}{Should the written validation expressions for an \emph{agent} be
expanded such that \strong{tidyselect} and \code{\link[=vars]{vars()}} expressions for columns are
evaluated, yielding a validation function per column? By default, this is
\code{FALSE} so expressions as written will be retained in the YAML
representation.}
}
\description{
With \strong{pointblank} YAML, we can serialize an agent's validation plan (with
\code{\link[=yaml_write]{yaml_write()}}), read it back later with a new agent (with
\code{\link[=yaml_read_agent]{yaml_read_agent()}}), or perform an interrogation on the target data table
directly with the YAML file (with \code{\link[=yaml_agent_interrogate]{yaml_agent_interrogate()}}). The
\code{yaml_agent_string()} function allows us to inspect the YAML generated by
\code{\link[=yaml_write]{yaml_write()}} in the console, giving us a look at the YAML without needing
to open the file directly. Alternatively, we can provide an \emph{agent} to the
\code{yaml_agent_string()} and view the YAML representation of the validation plan
without needing to write the YAML to disk beforehand.
}
\section{Function ID}{

11-5
}

\examples{
if (interactive()) {

# Let's create a validation plan for the
# data quality analysis of the `small_table`
# dataset; we need an agent and its
# table-prep formula enables retrieval
# of the target table
agent <- 
  create_agent(
    read_fn = ~small_table,
    label = "A simple example with the `small_table`.",
    actions = action_levels(
      warn_at = 0.10,
      stop_at = 0.25,
      notify_at = 0.35
    )
  ) \%>\%
  col_exists(vars(date, date_time)) \%>\%
  col_vals_regex(
    vars(b),
    regex = "[0-9]-[a-z]{3}-[0-9]{3}"
  ) \%>\%
  rows_distinct() \%>\%
  col_vals_gt(vars(d), value = 100) \%>\%
  col_vals_lte(vars(c), value = 5)

# We can view the YAML file in the console
# with the `yaml_agent_string()` function,
# providing the `agent` object as the input
yaml_agent_string(agent = agent)

# The agent can be written to a pointblank
# YAML file with `yaml_write()`
yaml_write(
  agent = agent,
  filename = "agent-small_table.yml"
)

# The 'agent-small_table.yml' file is
# available in the package through
# `system.file()`
yml_file <- 
  system.file(
    "yaml", "agent-small_table.yml",
    package = "pointblank"
  )

# The `yaml_agent_string()` function can
# be used with the YAML file as well
yaml_agent_string(filename = yml_file)

# At a later time, the YAML file can
# be read into a new agent with the
# `yaml_read_agent()` function
agent <- yaml_read_agent(filename = yml_file)
class(agent)

}
  
}
\seealso{
Other pointblank YAML: 
\code{\link{yaml_agent_interrogate}()},
\code{\link{yaml_agent_show_exprs}()},
\code{\link{yaml_exec}()},
\code{\link{yaml_informant_incorporate}()},
\code{\link{yaml_read_agent}()},
\code{\link{yaml_read_informant}()},
\code{\link{yaml_write}()}
}
\concept{pointblank YAML}
