% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_agent_report.R
\name{get_agent_report}
\alias{get_agent_report}
\title{Get a summary report from an agent}
\usage{
get_agent_report(
  agent,
  arrange_by = c("i", "severity"),
  keep = c("all", "fail_states"),
  display_table = TRUE,
  size = "standard",
  title = ":default:",
  lang = NULL,
  locale = NULL
)
}
\arguments{
\item{agent}{An agent object of class \code{ptblank_agent}.}

\item{arrange_by}{A choice to arrange the report table rows by the validation
step number (\code{"i"}, the default), or, to arrange in descending order by
severity of the failure state (with \code{"severity"}).}

\item{keep}{An option to keep \code{"all"} of the report's table rows (the
default), or, keep only those rows that reflect one or more
\code{"fail_states"}.}

\item{display_table}{Should a display table be generated? If \code{TRUE} (the
default), and if the \strong{gt} package is installed, a display table for the
report will be shown in the Viewer. If \code{FALSE}, or if \strong{gt} is not
available, then a tibble will be returned.}

\item{size}{The size of the display table, which can be either \code{"standard"}
(the default) or \code{"small"}. This only applies to a display table (where
\code{display_table = TRUE}).}

\item{title}{Options for customizing the title of the report. The default is
the keyword \code{":default:"} which produces generic title text that refers to
the \strong{pointblank} package in the language governed by the \code{lang} option.
Another keyword option is \code{":tbl_name:"}, and that presents the name of the
table as the title for the report. If no title is wanted, then the
\code{":none:"} keyword option can be used. Aside from keyword options, text can
be provided for the title and \code{glue::glue()} calls can be used to construct
the text string. If providing text, it will be interpreted as Markdown text
and transformed internally to HTML. To circumvent such a transformation,
use text in \code{\link[=I]{I()}} to explicitly state that the supplied text should not be
transformed.}

\item{lang}{The language to use for automatic creation of briefs (short
descriptions for each validation step) and for the \emph{agent report} (a
summary table that provides the validation plan and the results from the
interrogation. By default, \code{NULL} will create English (\code{"en"}) text. Other
options include French (\code{"fr"}), German (\code{"de"}), Italian (\code{"it"}), Spanish
(\code{"es"}), Portuguese (\code{"pt"}), Turkish (\code{"tr"}), Chinese (\code{"zh"}), Russian
(\code{"ru"}), Polish (\code{"pl"}), Danish (\code{"da"}), Swedish (\code{"sv"}), and Dutch
(\code{"nl"}). This \code{lang} option will override any previously set language
setting (e.g., by the \code{\link[=create_agent]{create_agent()}} call).}

\item{locale}{An optional locale ID to use for formatting values in the
\emph{agent report} summary table according the locale's rules. Examples include
\code{"en_US"} for English (United States) and \code{"fr_FR"} for French (France);
more simply, this can be a language identifier without a country
designation, like \code{"es"} for Spanish (Spain, same as \code{"es_ES"}). This
\code{locale} option will override any previously set locale value (e.g., by the
\code{\link[=create_agent]{create_agent()}} call).}
}
\value{
A \code{ptblank_agent_report} object if \code{display_table = TRUE} or a tibble
if \code{display_table = FALSE}.
}
\description{
We can get an informative summary table from an agent by using the
\code{get_agent_report()} function. The table can be provided in two substantially
different forms: as a \strong{gt} based display table (the default), or, as a
tibble. The amount of fields with intel is different depending on whether or
not the agent performed an interrogation (with the \code{\link[=interrogate]{interrogate()}} function).
Basically, before \code{\link[=interrogate]{interrogate()}} is called, the agent will contain just the
validation plan (however many rows it has depends on how many validation
functions were supplied a part of that plan). Post-interrogation, information
on the passing and failing test units is provided, along with indicators on
whether certain failure states were entered (provided they were set through
\code{actions}). The display table variant of the agent report, the default form,
will have the following columns:

\itemize{
\item i (unlabeled): the validation step number.
\item STEP: the name of the validation function used for the validation step,
\item COLUMNS: the names of the target columns used in the validation step
(if applicable).
\item VALUES: the values used in the validation step, where applicable; this
could be as literal values, as column names, an expression, etc.
\item TBL: indicates whether any there were any changes to the target table
just prior to interrogation. A rightward arrow from a small circle indicates
that there was no mutation of the table. An arrow from a circle to a purple
square indicates that preconditions were used to modify the target table. An
arrow from a circle to a half-filled circle indicates that the target table
has been segmented.
\item EVAL: a symbol that denotes the success of interrogation evaluation
for each step. A checkmark indicates no issues with evaluation. A warning
sign indicates that a warning occurred during evaluation. An explosion symbol
indicates that evaluation failed due to an error. Hover over the symbol for
details on each condition.
\item UNITS: the total number of test units for the validation step
\item PASS: on top is the absolute number of \emph{passing} test units and below
that is the fraction of \emph{passing} test units over the total number of test
units.
\item FAIL: on top is the absolute number of \emph{failing} test units and below
that is the fraction of \emph{failing} test units over the total number of test
units.
\item W, S, N: indicators that show whether the \code{warn}, \code{stop}, or \code{notify}
states were entered; unset states appear as dashes, states that are set with
thresholds appear as unfilled circles when not entered and filled when
thresholds are exceeded (colors for W, S, and N are amber, red, and blue)
\item EXT: a column that provides buttons to download data extracts as CSV
files for row-based validation steps having \strong{failing} test units. Buttons
only appear when there is data to collect.
}

The small version of the display table (obtained using \code{size = "small"})
omits the \code{COLUMNS}, \code{TBL}, and \code{EXT} columns. The width of the small table
is 575px; the standard table is 875px wide.

The \code{ptblank_agent_report} can be exported to a standalone HTML document
with the \code{\link[=export_report]{export_report()}} function.

If choosing to get a tibble (with \code{display_table = FALSE}), it will have the
following columns:

\itemize{
\item i: the validation step number.
\item type: the name of the validation function used for the validation step.
\item columns: the names of the target columns used in the validation step
(if applicable).
\item values: the values used in the validation step, where applicable; for
a \code{\link[=conjointly]{conjointly()}} validation step, this is a listing of all sub-validations.
\item precon: indicates whether any there are any preconditions to apply
before interrogation and, if so, the number of statements used.
\item active: a logical value that indicates whether a validation step is
set to \code{"active"} during an interrogation.
\item eval: a character value that denotes the success of interrogation
evaluation for each step. A value of \code{"OK"} indicates no issues with
evaluation. The \code{"WARNING"} value indicates a warning occurred during
evaluation. The \code{"ERROR"} VALUES indicates that evaluation failed due to an
error. With \code{"W+E"} both warnings and an error occurred during evaluation.
\item units: the total number of test units for the validation step.
\item n_pass: the number of \emph{passing} test units.
\item f_pass: the fraction of \emph{passing} test units.
\item W, S, N: logical value stating whether the \code{warn}, \code{stop}, or \code{notify}
states were entered. Will be \code{NA} for states that are unset.
\item extract: an integer value that indicates the number of rows available
in a data extract. Will be \code{NA} if no extract is available.
}
}
\section{Function ID}{

6-2
}

\examples{
# Create a simple table with a
# column of numerical values
tbl <- 
  dplyr::tibble(a = c(5, 7, 8, 5))

# Validate that values in column
# `a` are always greater than 4
agent <-
  create_agent(tbl = tbl) \%>\%
  col_vals_gt(vars(a), value = 4) \%>\%
  interrogate()

# Get a tibble-based report from the
# agent by using `get_agent_report()`
# with `display_table = FALSE`
agent \%>\%
  get_agent_report(display_table = FALSE)
  
# View a the report by printing the
# `agent` object anytime, but, return a
# gt table object by using this with
# `display_table = TRUE` (the default)
report <- get_agent_report(agent)
class(report)

# What can you do with the report?
# Print it from an R Markdown code,
# use it in an email, put it in a
# webpage, or further modify it with
# the **gt** package

# The agent report as a **gt** display
# table comes in two sizes: "standard"
# (the default) and "small"
small_report <- 
  get_agent_report(
    agent = agent,
    size = "small"
  )

class(small_report)

# The standard report is 875px wide
# the small one is 575px wide

}
\seealso{
Other Interrogate and Report: 
\code{\link{interrogate}()}
}
\concept{Interrogate and Report}
