% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/focus_on.R
\name{focus_on}
\alias{focus_on}
\title{Place certain access details more to the fore}
\usage{
focus_on(agent, tbl_name = NULL, file_name = NULL, col_types = NULL,
  db_type = NULL, creds_file = NULL, initial_sql = NULL,
  description = NULL)
}
\arguments{
\item{agent}{an agent object of class
\code{ptblank_agent}.}

\item{tbl_name}{the name of the local or remote
table.}

\item{file_name}{the name of a file to be
loaded as a table. Valid types are CSV and TSV
files.}

\item{col_types}{if validating a CSV or TSV file,
an optional column specification can be provided
here as a string. This string representation is
where each character represents one column and the
mappings are: \code{c} -> character, \code{i} ->
integer, \code{n} -> number, \code{d} -> double, 
\code{l} -> logical, \code{D} -> date, \code{T} ->
date time, \code{t} -> time, \code{?} -> guess, 
or \code{_/-}, which skips the column.}

\item{db_type}{if the table is located in a
database, the type of database is required here.
Currently, this can be either \code{PostgreSQL}
or \code{MySQL}.}

\item{creds_file}{if a connection to a database
is required for reaching the table specified in
\code{tbl_name}, then a path to a credentials file
can be used to establish that connection. The
credentials file is an \code{RDS} containing a
character vector with the following items in the
specified order: (1) database name (\code{dbname}),
(2) the \code{host} name, (3) the \code{port},
(4) the username (\code{user}), and (5) the
\code{password}. This file can be easily created
using the \code{create_creds_file()} function.}

\item{initial_sql}{when accessing a remote table,
this provides an option to provide an initial
query component before conducting validations. 
An entire SQL statement can be provided here, or,
as a shortcut, the initial \code{SELECT...}
statement can be omitted for simple queries (e.g.,
\code{WHERE a > 1 AND b = 'one'}).}

\item{description}{an optional, text-based
description for the validation step. Used primarily
in the Logical Plan section of the report generated
by the \code{html_summary} function.}
}
\value{
an agent object.
}
\description{
Allows for a change of the 
focus on the table name, database type, and
the location of the credentials file.
}
\examples{
# Create a simple data frame with a column
# of numerical values
df <-
  data.frame(
    a = c(5, 4, 3, 5, 1, 2))

# Validate that values in column `a` are
# always less than 6; this requires the
# use of `create_agent()` (to begin the 
# validation process) and `focus_on()`
# to point to the table that will undergo
# validation in subsequent steps
agent <-
  create_agent() \%>\%
  focus_on(tbl_name = "df") \%>\%
  col_vals_lt(
    column = "a",
    value = 6) \%>\%
  interrogate()

# Determine if this column validation has
# passed by using `all_passed()`
all_passed(agent)
#> [1] TRUE
}
