% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lowpass13.R
\name{lowpass13}
\alias{lowpass13}
\title{Apply 13-year low-pass filter}
\usage{
lowpass13(data)
}
\arguments{
\item{data}{a \code{data.frame} with raw tree-ring series as columns and years as rows (e.g., output of \code{read.rwl} of package dplR).}
}
\value{
The function returns a \code{data.frame} with 13-year low-pass filtered index series.
}
\description{
The function applies a 13-year weighted low-pass filter, as described by Fritts (1976), on a \code{data.frame} with tree-ring series.
}
\details{
A 13-year weighted low-pass filter, as described by Fritts (1976, p. 270), can be applied to tree-ring series prior to the calculation of event and pointer years using \code{\link{pointer.norm}}. According to Cropper (1979), such a filter improves the detection of event and pointer years for complacent series, whereas for sensitive series filtering has little effect.

Note that the resulting time series are truncated by 6 years at both ends inherent to the calculation method.
}
\examples{
data(s033)
lp13_s033 <- lowpass13(s033)

}
\references{
Cropper, J.P. (1979) Tree-ring skeleton plotting by computer. \emph{Tree-Ring Bulletin} 39: 47-59.

Fritts, H.C. (1976) Tree rings and climate. Academic Press Inc. (London) Ltd.
}
\author{
Marieke van der Maaten-Theunissen and Ernst van der Maaten.
}
