% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event.plot.R
\name{event.plot}
\alias{event.plot}
\title{Plot event years for individual trees}
\usage{
event.plot(list.name, sign = c("both", "pos", "neg"),
           period = NULL, x.tick.major = 10, x.tick.minor = 5)
}
\arguments{
\item{list.name}{a \code{list} as produced by \code{\link{pointer.norm}} or \code{\link{pointer.rgc}}}

\item{sign}{a \code{character} string specifying whether both positive and negative (\code{"both"}), or only positive (\code{"pos"}) or negative (\code{"neg"}) event years should be displayed. Defaults to \code{"both"}.}

\item{period}{a \code{vector} specifying the start and end year to be plotted. Defaults to the full period covered by the output of the pointer year analysis.}

\item{x.tick.major}{an \code{integer} controlling the major x-axis tick labels. Defaults to 10 years.}

\item{x.tick.minor}{an \code{integer} controlling the minor x-axis ticks. Defaults to 5 years.}
}
\value{
Dot plot.
}
\description{
The function creates a dot plot showing positive and (or) negative event years from a \code{list} of the type as produced by \code{\link{pointer.norm}} or \code{\link{pointer.rgc}}.
}
\details{
The function makes a dot plot showing event years for individual trees. Positive and negative event years are indicated with different symbols and (or) colors.
}
\examples{
## Plot event years from pointer.rgc output
data(s033)
py <- pointer.rgc(s033)
event.plot(py) 

## Plot negative event years from pointer.norm output (method "Neuwirth") for a specific period
data(s033)
detr_s033 <- detrend(s033, method = "Spline", nyrs = 30)
pyn <- pointer.norm(detr_s033, method.thresh = "Neuwirth")
event.plot(pyn, sign = "neg", period = c(1950, 2007)) 
           
}
\author{
Marieke van der Maaten-Theunissen and Ernst van der Maaten.
}
