% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table_names.R
\name{get_table_names}
\alias{get_table_names}
\title{Get Table Names from PODR}
\usage{
get_table_names(
  con = getOption("podr_connection"),
  query_string = NULL,
  lib_sel = NULL,
  ds_sel = NULL
)
}
\arguments{
\item{con}{The connection to PODR. Use connect_podr to establish a connection, or specify a variable
containing the proper PostgreSQL connection into PODR yourself}

\item{query_string}{provides full SQL statement}

\item{lib_sel}{Library name selection pattern}

\item{ds_sel}{Dataset name selection pattern}
}
\value{
The selected table names in a data.frame
}
\description{
This function will get a list of table names from "PODR".
}
\examples{
\dontrun{
cc <- conn_podr()
get_table_names(con=cc)
get_table_names(query_string = "select * from information_schema.tables")
get_table_names(query_string = "select * from information_schema.tables", lib_sel = "readme")
}

}
\author{
Hanming Tu
}
