\name{apecm1.step.spmd}
\alias{apecm1.step.spmd}
\title{APECM1 Steps for SPMD}
\description{
  The APECM1 algorithm for model-based clustering of finite mixture Gaussian
  models with unstructured dispersions.
}
\usage{
  apecm1.step.spmd(PARAM.org)
}
\arguments{
  \item{PARAM.org}{an original set of parameters generated
                   by \code{\link{set.global}}.}
}
\details{
  A global variable called \code{\link{X.spmd}} should exist in the
  \code{\link[base]{.GlobalEnv}}
  environment, usually the working environment. The \code{\link{X.spmd}}
  is the data matrix to be clustered, and this matrix has a dimension
  \code{N.spmd} by \code{p}.

  A \code{PARAM.org} will be a local variable inside
  \code{\link{apecm1.step.spmd}},
  and this variable is a list containing all parameters related to models.
  This function also updates in the parameters by the APECM1 algorithm, and
  return the convergent results. The details of list elements are initially
  generated by \code{\link{set.global}}.
}
\value{
  A convergent results will be returned in the other list variables
  containing all new parameters which represent the components of models.
  See the help page of \code{\link{PARAM}} or \code{\link{PARAM.org}}
  for details.
}
\references{
  High Performance Statistical Computing Website:
  \url{http://thirteen-01.stat.iastate.edu/snoweye/hpsc/}

  Chen, W.-C. and Maitra, R. (2011)
  \dQuote{Model-based clustering of regression time series data via
          APECM -- an AECM algorithm sung to an even faster beat},
  \emph{Statistical Analysis and Data Mining},
  \bold{4}, 567-578.
}
\author{
  Wei-Chen Chen \email{wccsnow@gmail.com} and George Ostrouchov.
}
\seealso{
  \code{\link{set.global}},
  \code{\link{mb.print}},
  \code{\link{em.step.spmd}},
  \code{\link{aecm.step.spmd}}, \cr
  \code{\link{apecm2.step.spmd}}.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run in 4 processors by
# > mpirun -np 4 Rscript demo.r

### Setup mpi environment.
library(Rmpi)
library(pmclust)
invisible(mpi.comm.dup(0, 1))

### Generate an example data.
N.allspmds <- rep(5000, mpi.comm.size())
N.spmd <- 5000
N.K.spmd <- c(2000, 3000)
N <- 5000 * mpi.comm.size()
p <- 2
K <- 2
seed <- 123 + mpi.comm.rank()
data.spmd <- generate.basic.spmd(N.allspmds, N.spmd, N.K.spmd,
                                     N, p, K, seed)
X.spmd <- data.spmd$X.spmd

### Run clustering.
PARAM.org <- set.global(K = K)
# PARAM.org <- initial.em.spmd(PARAM.org)
PARAM.org <- initial.RandEM.spmd(PARAM.org)
PARAM.new <- apecm1.step.spmd(PARAM.org)
em.update.class.spmd()

### Get results.
N.CLASS <- get.N.CLASS(K)
catmpi("# of class:", N.CLASS, "\n")

### Quit Rmpi.
mpi.quit()
}
}
\keyword{algorithm}

