% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shaving.R
\name{shaving}
\alias{plot.shaved}
\alias{print.shaved}
\alias{shaving}
\title{Repeated shaving of variables}
\usage{
shaving(y, X, ncomp = 10, method = c("SR", "VIP", "sMC", "LW", "RC"),
  prop = 0.2, min.left = 1, comp.type = c("CV", "max"),
  validation = c("CV", 1), newy = NULL, newX = NULL, segments = 10, ...)

\method{plot}{shaved}(x, y, what = c("error", "spectra"), index = "min",
  log = "x", ...)

\method{print}{shaved}(x, ...)
}
\arguments{
\item{y}{vector of response values (\code{numeric} or \code{factor}).}

\item{X}{numeric predictor \code{matrix}.}

\item{ncomp}{integer number of components (default = 10).}

\item{method}{filter method, i.e. SR, VIP, sMC, LW or RC given as \code{character}.}

\item{prop}{proportion of variables to be removed in each iteration (\code{numeric}).}

\item{min.left}{minimum number of remaining variables.}

\item{comp.type}{use number of components chosen by cross-validation, \code{"CV"},
or fixed, \code{"max"}.}

\item{validation}{type of validation for \code{plsr}. The default is "CV". If more
than one set of CV segments is wanted, use a vector of lenth two, e.g. \code{c("CV",5)}.}

\item{newy}{validation response for RMSEP/error computations.}

\item{newX}{validation predictors for RMSEP/error computations.}

\item{segments}{see \code{mvr} for documentation of segment choices.}

\item{...}{additional arguments for \code{plsr} or \code{cvsegments}.}

\item{x}{object of class \code{shaved} for plotting or printing.}

\item{what}{plot type. Default = "error". Alternative = "spectra".}

\item{index}{which iteration to plot. Default = "min"; corresponding to minimum RMSEP.}

\item{log}{logarithmic x (default) or y scale.}
}
\value{
Returns a list object of class \code{shaved} containing the method type,
the error, number of components, and number of variables per reduced model. It
also contains a list of all sets of reduced variable sets plus the original data.
}
\description{
One of five filter methods can be chosen for repeated shaving of
a certain percentage of the worst performing variables. Performance of the
reduced models are stored and viewable through \code{print} and \code{plot}
methods.
}
\details{
Variables are first sorted with respect to some importancemeasure, 
and usually one of the filter measures described above are used. Secondly, a 
threshold is used to eliminate a subset of the least informative variables. Then
a model is fitted again to the remaining variables and performance is measured. 
The procedure is repeated until maximum model performance is achieved.
}
\examples{
data(mayonnaise, package = "pls")
sh <- shaving(mayonnaise$design[,1], pls::msc(mayonnaise$NIR), type = "interleaved")
pars <- par(mfrow = c(2,1), mar = c(4,4,1,1))
plot(sh)
plot(sh, what = "spectra")
par(pars)
print(sh)

}
\author{
Kristian Hovde Liland
}
\seealso{
\code{\link{VIP}} (SR/sMC/LW/RC), \code{\link{filterPLSR}}, \code{\link{spa_pls}}, 
\code{\link{stpls}}, \code{\link{truncation}}, \code{\link{bve_pls}}, \code{\link{mcuve_pls}},
\code{\link{ipw_pls}}, \code{\link{ga_pls}}, \code{\link{rep_pls}}.
}

