% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_composite2.R
\name{image_composite2}
\alias{image_composite2}
\title{Centering Two Images and Creating a Composite Image}
\usage{
image_composite2(a, b, operator = "in", offset = "middle",
  compose_args = "", scale = TRUE)
}
\arguments{
\item{a}{image.}

\item{b}{another image.}

\item{operator}{this character will be passed to 
\code{magick::image_composite}. It can be "in", "out", 
"atop", "blend", etc.Default is "in". For instance, if it 
is "in", then a part of image b is kept and the shape of 
this part is the same as the shape of image a. If it is 
"out", a hole with the shape of a will be left.}

\item{offset}{how to put a and b together in order to 
combine them. If it is written in the format like "+0+0", 
then it will be passed to \code{magick::image_composite}
directly. However, it also can be the following values: 
\itemize{
  \item (1) middle or center: which is the default. 
Now a is put at the center of b.
  \item (2) samea: adjust the size of b according to 
a and then combine them.
  \item (3) sameb: adjust the size of a according to 
b and then combine them.
  \item (4) height: adjust the height of a according to
the height of b.
  \item (5) width: adjust the width of a according to 
the width of b.
  \item (6) a>b: this is used only when a is bigger than 
b and you want to blend a with b.
}}

\item{compose_args}{this will be passed 
to \code{magick::image_composite}.}

\item{scale}{whether to keep ratio in resizing a 
when \code{offset} is "width" or "height". 
Default is TRUE.}
}
\description{
The function is a convenient wrapper of 
\code{magick::image_composite}. However, 
the \code{offset} parameter of the latter is 
difficult to handle. The function centers a 
image and b image in different ways and then 
combines them. See the \code{offset} parameter
off this function.
}
