% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{color_contour}
\alias{color_contour}
\title{Creates a contour plot with colored background.}
\usage{
color_contour(x = seq(0, 1, length.out = nrow(z)), y = seq(0, 1, length.out
  = ncol(z)), z, main = NULL, xlab = NULL, ylab = NULL, xlim = NULL,
  ylim = NULL, zlim = NULL, col = NULL, color = topo.colors(50),
  nCol = 50, add.color.legend = TRUE, ...)
}
\arguments{
\item{x}{Locations of grid lines at which the values in z are measured. 
These must be in ascending order. By default, equally spaced values from 0 
to 1 are used. If x is a list, its components x$x and x$y are used for x 
and y, respectively. If the list has component z this is used for z.}

\item{y}{Locations of grid lines at which the values in z are measured.}

\item{z}{a matrix containing the values to be plotted (NAs are allowed). 
Note that x can be used instead of z for convenience.}

\item{main}{Text string, an overall title for the plot.}

\item{xlab}{Label for x axis. Default is name of first \code{view} variable.}

\item{ylab}{Label for y axis. Default is name of second \code{view} 
variable.}

\item{xlim}{x-limits for the plot.}

\item{ylim}{y-limits for the plot.}

\item{zlim}{z-limits for the plot.}

\item{col}{Color for the  contour lines and labels.}

\item{color}{a list of colors such as that generated by 
\code{\link[grDevices]{rainbow}}, \code{\link[grDevices]{heat.colors}}
\code{\link[grDevices]{colors}}, \code{\link[grDevices]{topo.colors}}, 
\code{\link[grDevices]{terrain.colors}} or similar functions.}

\item{nCol}{The number of colors to use in color schemes.}

\item{add.color.legend}{Logical: whether or not to add a color legend. 
Default is TRUE. If FALSE (omitted), one could use the function
\code{\link{gradientLegend}} to add a legend manually at any position.}

\item{...}{Optional parameters for \code{\link[graphics]{image}}
and \code{\link[graphics]{contour}}.}
}
\description{
This function is a wrapper around \code{\link[graphics]{image}}
and \code{\link[graphics]{contour}}. See \code{vignette("plotfunctions")} 
for an example of how you could use \code{\link[graphics]{image}} and 
\code{\link[graphics]{contour}}.
}
\examples{

# Volcano example of R (package datasets)
color_contour(z=volcano)
# change color and lines:
color_contour(z=volcano, color='terrain', col=alpha(1), lwd=2, lty=5)
# change x-axis values and zlim:
color_contour(x=seq(500,700, length=nrow(volcano)),
    z=volcano, color='terrain', col=alpha(1), lwd=2, zlim=c(0,200))

# compare with similar functions:
filled.contour(volcano, color.palette=terrain.colors)

# without contour lines:
color_contour(z=volcano, color='terrain', lwd=0, drawlabels=FALSE)
# without background:
color_contour(z=volcano, color=NULL, add.color.legend=FALSE)
}
\author{
Jacolien van Rij
}
\seealso{
\code{\link[graphics]{image}}, \code{\link[graphics]{contour}},
\code{\link[graphics]{filled.contour}}. See \code{\link{plotsurface}}
for plotting model predictions using \code{color_contour}.

\code{\link{plotsurface}}

Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{add_n_points}},
  \code{\link{alphaPalette}}, \code{\link{alpha}},
  \code{\link{check_normaldist}},
  \code{\link{dotplot_error}}, \code{\link{drawArrows}},
  \code{\link{emptyPlot}}, \code{\link{errorBars}},
  \code{\link{fill_area}}, \code{\link{getCoords}},
  \code{\link{getFigCoords}}, \code{\link{getProps}},
  \code{\link{gradientLegend}},
  \code{\link{legend_margin}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_error}}, \code{\link{plot_image}},
  \code{\link{plotsurface}}
}

