% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_cips.R
\name{cipstest}
\alias{cipstest}
\title{Cross-sectionally Augmented IPS Test for Unit Roots in Panel Models}
\usage{
cipstest(x, lags = 2, type = c("trend", "drift", "none"),
  model = c("cmg", "mg", "dmg"), truncated = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{"pseries"},}

\item{lags}{lag order for Dickey-Fuller augmentation,}

\item{type}{one of \code{"trend"}, \code{"drift"}, \code{"none"},}

\item{model}{one of \code{"cmg"}, \code{"mg"}, \code{"dmg"},}

\item{truncated}{logical specifying whether to calculate the
truncated version of the test,}

\item{\dots}{further arguments passed to \code{critvals}.}
}
\value{
An object of class \code{"htest"}.
}
\description{
Cross-sectionally augmented Im, Pesaran and Shin (IPS) test for
unit roots in panel models.
}
\details{
This cross-sectionally augmented version of the IPS unit root test
(H0: the \code{pseries} has a unit root) is a so-called
second-generation panel unit root test: it is in fact robust
against cross-sectional dependence, provided that the default
\code{type="cmg"} is calculated. Else one can obtain the standard
(\code{model="mg"}) or cross-sectionally demeaned (\code{model="dmg"})
versions of the IPS test.

% TODO: maybe be more verbose here? write about type arg which corresponds
% cases III, II, I in Pesaran (2007) etc.
}
\examples{

data("Produc", package = "plm")
Produc <- pdata.frame(Produc, index=c("state", "year"))
## check whether the gross state product (gsp) is trend-stationary
cipstest(Produc$gsp, type = "trend")

}
\references{
\insertRef{pes07}{plm}
}
\seealso{
\code{\link[=purtest]{purtest()}}
}
\author{
Giovanni Millo
}
\keyword{htest}
